/*
 Source Server Type    : MySQL
 Source Server Version : 80037 (8.0.37-0ubuntu0.24.04.1)
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for area
-- ----------------------------
DROP TABLE IF EXISTS `area`;
CREATE TABLE `area` (
  `areacode` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `areaname` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT NULL,
  PRIMARY KEY (`areacode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='参加者の都道府県エリア';

-- ----------------------------
-- Table structure for chat_log3
-- ----------------------------
DROP TABLE IF EXISTS `chat_log3`;
CREATE TABLE `chat_log3` (
  `log_id` int NOT NULL AUTO_INCREMENT,
  `room_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `file_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `file_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `original_file_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `to_user_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_system` tinyint(1) DEFAULT '0' COMMENT 'システムメッセージフラグ',
  `expires_at` datetime DEFAULT NULL COMMENT 'このログの有効期限',
  PRIMARY KEY (`log_id`),
  KEY `idx_room_id_log_id` (`room_id`,`log_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='チャットログ';

-- ----------------------------
-- Table structure for chat_rooms
-- ----------------------------
DROP TABLE IF EXISTS `chat_rooms`;
CREATE TABLE `chat_rooms` (
  `room_id` int NOT NULL AUTO_INCREMENT,
  `room_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `started_at` timestamp NULL DEFAULT NULL COMMENT '実質的なチャットが開始された日時',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最終メッセージ投稿日時または作成日時',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0' COMMENT '入室が制限されているか (1:制限中, 0:オープン)',
  `description` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'ルームの一言メッセージ',
  `fixed` tinyint DEFAULT '0',
  `test_flag` tinyint DEFAULT '0',
  `roomsort` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'zzz' COMMENT '表示順ソートキー',
  `roomgroup` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '999' COMMENT 'ルームのグループキー',
  `roomcolor` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'white' COMMENT 'ルーム名の色',
  `flag_meet` tinyint(1) NOT NULL DEFAULT '0' COMMENT '待ち合わせフラグ',
  `flag_chatplay` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'イメチャフラグ',
  `flag_onlyreal` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'リアルのみフラグ',
  `flag_friend` tinyint(1) NOT NULL DEFAULT '0' COMMENT '彼氏募集フラグ',
  PRIMARY KEY (`room_id`),
  UNIQUE KEY `room_name` (`room_name`),
  KEY `idx_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='チャット部屋一覧';

-- ----------------------------
-- Table structure for hope
-- ----------------------------
DROP TABLE IF EXISTS `hope`;
CREATE TABLE `hope` (
  `hopeid` int NOT NULL AUTO_INCREMENT,
  `hope` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `hopes_cnt` int DEFAULT NULL,
  PRIMARY KEY (`hopeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='チャットの希望の相手';

-- ----------------------------
-- Table structure for online_status
-- ----------------------------
DROP TABLE IF EXISTS `online_status`;
CREATE TABLE `online_status` (
  `user_id` int NOT NULL,
  `room_id` int NOT NULL,
  `last_active` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '入室日時',
  `message_cnt` int unsigned NOT NULL DEFAULT '0' COMMENT '発言回数',
  PRIMARY KEY (`user_id`,`room_id`),
  KEY `idx_room_id` (`room_id`),
  KEY `idx_room_id_created_at` (`room_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='オンライン状態管理専用テーブル';

-- ----------------------------
-- Table structure for reports
-- ----------------------------
DROP TABLE IF EXISTS `reports`;
CREATE TABLE `reports` (
  `report_id` int NOT NULL AUTO_INCREMENT,
  `log_id` int NOT NULL COMMENT '通報対象のチャットログID',
  `room_id` int NOT NULL COMMENT 'ルームID',
  `reporter_user_id` int NOT NULL COMMENT '通報したユーザーID',
  `reported_user_id` int NOT NULL COMMENT '通報されたユーザーID',
  `reported_user_ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '通報されたユーザーのIPアドレス',
  `image_file_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '通報された画像のパス',
  `report_reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '通報理由（将来の拡張用）',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`report_id`),
  KEY `idx_log_id` (`log_id`),
  KEY `idx_reported_user_id` (`reported_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='画像通報ログ';

-- ----------------------------
-- Table structure for systemmessage
-- ----------------------------
DROP TABLE IF EXISTS `systemmessage`;
CREATE TABLE `systemmessage` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='チャットのシステムからのお知らせ表示用html';

-- ----------------------------
-- Table structure for taste
-- ----------------------------
DROP TABLE IF EXISTS `taste`;
CREATE TABLE `taste` (
  `feelid` int NOT NULL AUTO_INCREMENT,
  `feel` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `sortkey` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`feelid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='参加者の嗜好の項目';

-- ----------------------------
-- Table structure for typing_status
-- ----------------------------
DROP TABLE IF EXISTS `typing_status`;
CREATE TABLE `typing_status` (
  `user_id` int unsigned NOT NULL,
  `room_id` int unsigned NOT NULL,
  `is_typing` tinyint(1) NOT NULL DEFAULT '0',
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Table structure for users3
-- ----------------------------
DROP TABLE IF EXISTS `users3`;
CREATE TABLE `users3` (
  `user_id` int NOT NULL AUTO_INCREMENT,
  `unique_user_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `user_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `icon_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'default_icon.png',
  `deny` tinyint(1) NOT NULL DEFAULT '0',
  `denied_at` timestamp NULL DEFAULT NULL COMMENT '強制退室させられた日時',
  `last_login_date` datetime DEFAULT NULL,
  `host_ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `last_active` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_active_room_id` int DEFAULT NULL,
  `is_typing` tinyint(1) NOT NULL DEFAULT '0',
  `beep_enabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '通知音を有効にするか (1:有効, 0:無効)',
  `delete_logs_on_logout` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ログアウト時にログを削除するか (1:削除する, 0:しない)',
  `is_spectator` tinyint(1) NOT NULL DEFAULT '0' COMMENT '覗き見モードフラグ',
  `auto_leave_on_close` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'ブラウザ閉じたら自動退室',
  `log_expire_days` int NOT NULL DEFAULT '1' COMMENT 'ログ有効日数 (0:退室時, 1:1日, 7:7日, -1:無期限)',
  `height` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '身長',
  `weight` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '体重',
  `age` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '年齢',
  `usertype` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'ユーザータイプ',
  `tastes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '選択されたtaste (カンマ区切り)',
  `last_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '最後に投稿したメッセージ',
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '最終ログイン時のユーザーエージェント',
  `device_type` varchar(10) COLLATE utf8mb4_general_ci DEFAULT 'pc',
  `wants` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '選択されたwant (カンマ区切り)',
  `hopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '選択されたhope (カンマ区切り)',
  `profile_message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'プロフィールの一言メッセージ',
  `areaname` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'エリア（都道府県）',
  `flag_meet` tinyint(1) NOT NULL DEFAULT '0',
  `flag_chatplay` tinyint(1) NOT NULL DEFAULT '0',
  `flag_onlyreal` tinyint(1) NOT NULL DEFAULT '0',
  `flag_friend` tinyint(1) NOT NULL DEFAULT '0',
  `survey` tinyint DEFAULT NULL,
  `checked` tinyint DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `unique_user_id` (`unique_user_id`),
  KEY `idx_last_active_room_id_last_active` (`last_active_room_id`,`last_active`),
  KEY `idx_last_active` (`last_active`),
  KEY `idx_last_active_room_id` (`last_active_room_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='チャット参加者';

-- ----------------------------
-- Table structure for usertype
-- ----------------------------
DROP TABLE IF EXISTS `usertype`;
CREATE TABLE `usertype` (
  `usertype` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `typecolor` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `sortkey` int NOT NULL DEFAULT '0' COMMENT '表示順ソートキー',
  `type_cnt` int DEFAULT NULL,
  PRIMARY KEY (`usertype`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='参加者のタイプ';

-- ----------------------------
-- Table structure for want
-- ----------------------------
DROP TABLE IF EXISTS `want`;
CREATE TABLE `want` (
  `wantid` int NOT NULL AUTO_INCREMENT,
  `want` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `want_cnt` int DEFAULT NULL,
  PRIMARY KEY (`wantid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='参加者の希望の相手';

SET FOREIGN_KEY_CHECKS = 1;
