<?php
// FILE: index.php (LAYOUT RESTRUCTURE & STYLE - FULL VERSION)
session_start([ 'cookie_samesite' => 'None', 'cookie_secure' => true, 'cookie_httponly' => true, ]);
require_once 'config.php';
require_once 'functions.php';
require_once 'db.php';
generate_csrf_token();
$pdo = get_pdo();

if (rand(1, 100) === 1) {
	try {
		$pdo->exec("UPDATE users3 SET icon_image = 'default_icon.png' WHERE icon_image = '' OR icon_image IS NULL");
	} catch (PDOException $e) { error_log("Index page maintenance query failed: " . $e->getMessage()); }
}
try {
	$usertypes = $pdo->query("SELECT usertype FROM usertype ORDER BY sortkey ASC, usertype ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
	$tastes = $pdo->query("SELECT feel FROM taste ORDER BY sortkey ASC, feel ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
	$wants = $pdo->query("SELECT want FROM want ORDER BY wantid ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
	$hopes = $pdo->query("SELECT hope FROM hope ORDER BY hopeid ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
	$areas = $pdo->query("SELECT areaname FROM area ORDER BY areacode ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
	$system_message_raw = $pdo->query("SELECT message FROM systemmessage ORDER BY id DESC LIMIT 1")->fetchColumn() ?: '';
	
	$user_profile = [ 
		'user_name' => '', 'height' => '', 'weight' => '', 'age' => '', 
		'usertype' => '', 'areaname' => '', 'beep_enabled' => '1', 
		'delete_logs_on_logout' => '0', 
		'log_expire_days' => '1',
		'tastes' => [], 'wants' => [], 'hopes' => [],
		'flag_meet' => $_COOKIE['flag_meet'] ?? '0',
		'flag_chatplay' => $_COOKIE['flag_chatplay'] ?? '0',
		'flag_onlyreal' => $_COOKIE['flag_onlyreal'] ?? '0',
		'flag_friend' => $_COOKIE['flag_friend'] ?? '0'
	];
	
	$my_user_id = 0;

	if (isset($_COOKIE[COOKIE_NAME])) {
		$stmt_user = $pdo->prepare("SELECT user_id, user_name, height, weight, age, usertype, areaname, beep_enabled, delete_logs_on_logout, log_expire_days, tastes, wants, hopes, flag_meet, flag_chatplay, flag_onlyreal, flag_friend FROM users3 WHERE unique_user_id = :unique_id");
		$stmt_user->execute([':unique_id' => $_COOKIE[COOKIE_NAME]]);
		$user = $stmt_user->fetch();
		if ($user) {
			$my_user_id = $user['user_id'];
			$user_profile['user_name'] = h($user['user_name'] ?? ''); $user_profile['height'] = h($user['height'] ?? ''); $user_profile['weight'] = h($user['weight'] ?? ''); $user_profile['age'] = h($user['age'] ?? ''); $user_profile['usertype'] = h($user['usertype'] ?? ''); $user_profile['areaname'] = h($user['areaname'] ?? ''); $user_profile['beep_enabled'] = h($user['beep_enabled'] ?? '1'); $user_profile['delete_logs_on_logout'] = h($user['delete_logs_on_logout'] ?? '0');
			if (isset($user['log_expire_days'])) { $user_profile['log_expire_days'] = h($user['log_expire_days']); }
			if (!empty($user['tastes'])) { $user_profile['tastes'] = explode(',', $user['tastes']); } if (!empty($user['wants'])) { $user_profile['wants'] = explode(',', $user['wants']); } if (!empty($user['hopes'])) { $user_profile['hopes'] = explode(',', $user['hopes']); }
			if (isset($user['flag_meet'])) $user_profile['flag_meet'] = $user['flag_meet'];
			if (isset($user['flag_chatplay'])) $user_profile['flag_chatplay'] = $user['flag_chatplay'];
			if (isset($user['flag_onlyreal'])) $user_profile['flag_onlyreal'] = $user['flag_onlyreal'];
			if (isset($user['flag_friend'])) $user_profile['flag_friend'] = $user['flag_friend'];
		}
	}
} catch (PDOException $e) { error_log("Index page data fetch failed: " . $e->getMessage()); $usertypes = []; $tastes = []; $wants = []; $hopes = []; $areas = []; $system_message_raw = '<p class="text-danger">データの取得に失敗しました。</p>'; }
$error = $_SESSION['error'] ?? ''; unset($_SESSION['error']);
$my_hopes_str = implode(',', $user_profile['hopes']);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
	<meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= h(SITE_NAME) ?>へようこそ</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
	<link rel="stylesheet" href="assets/css/chat.css?v=<?php echo time(); ?>">
	<style>
		.btn-no-wrap { white-space: nowrap; }
		.list-group-flush .list-group-item {
			background-color: transparent;
			border: none;
			border-bottom: 1px solid rgba(255, 255, 255, 0.1);
			padding: 0.75rem 1rem;
			transition: border-left-color 0.2s ease-in-out, background-color 0.2s ease-in-out;
			border-left: 5px solid transparent;
		}
		.list-group-flush .list-group-item:last-child { border-bottom: none; }
		.list-group-item strong, .list-group-item .join-room-btn { transition: all 0.2s ease-out; }
		
		.list-group-item.available-room {
			background-color: <?= h(ROOM_BG_AVAILABLE) ?> !important;
		}
		.list-group-item.locked-room {
			background-color: <?= h(ROOM_BG_LOCKED) ?> !important;
		}

		.list-group-item.hover-effect:hover { 
			cursor: pointer; 
			border-left-color: #198754;
		}
		.list-group-item.locked-item:hover { 
			cursor: default; 
			border-left-color: #dc3545;
		}
		.list-group-item.hover-effect:hover strong {
			background-color: #198754;
			border-radius: .25rem;
			padding: 0.1rem 0.3rem;
			color: white !important;
		}
	</style>
</head>
<body data-bs-theme="dark" data-my-userid="<?= h($my_user_id) ?>" data-my-hopes="<?= h($my_hopes_str) ?>">
	<div class="container-fluid pt-2 pb-2 h-100">
		<div class="row justify-content-center h-100">
			<div class="col h-100">
				<div class="card main-card">
					<div class="fixed-section">
						<div class="card-header text-center"><h3><?= h(SITE_NAME) ?>に参加</h3></div>
						<div class="card-body pb-2">
							<?php if ($error): ?><div class="alert alert-danger p-2 mb-2"><?= $error ?></div><?php endif; ?>
							<input type="text" class="form-control mb-2" id="user_name" value="<?= $user_profile['user_name'] ?>" placeholder="ユーザー名 *" required>
							<div class="d-flex flex-wrap align-items-center column-gap-3 row-gap-1">
								<div class="form-check form-switch">
									<input class="form-check-input" type="checkbox" id="beep_enabled" value="1" <?= ($user_profile['beep_enabled'] == 1) ? 'checked' : '' ?>>
									<label class="form-check-label small" for="beep_enabled">通知音</label>
								</div>
								<div class="form-check form-switch">
									<input class="form-check-input" type="checkbox" id="is_spectator" value="1">
									<label class="form-check-label small" for="is_spectator"><?= ICON_SPECTATOR ?> 覗き見する</label>
								</div>
							</div>
						</div>
					</div>
					<div class="scrollable-section"> 
						<div class="card-body pt-2">
							<div class="row g-2 mb-2">
								<div class="col-6"><select class="form-select" id="usertype"><option value="" <?= ($user_profile['usertype'] == '') ? 'selected' : '' ?>>タイプ選択</option><?php foreach ($usertypes as $type): ?><option value="<?= h($type) ?>" <?= ($user_profile['usertype'] == $type) ? 'selected' : '' ?>><?= h($type) ?></option><?php endforeach; ?></select></div>
								<div class="col-6"><select class="form-select" id="areaname"><option value="" selected>エリア未指定</option><?php foreach ($areas as $area): ?><option value="<?= h($area) ?>" <?= ($user_profile['areaname'] == $area) ? 'selected' : '' ?>><?= h($area) ?></option><?php endforeach; ?></select></div>
							</div>
							<div class="row g-2 mb-2">
								<div class="col"><input type="text" class="form-control" id="height" value="<?= $user_profile['height'] ?>" placeholder="身長"></div>
								<div class="col"><input type="text" class="form-control" id="weight" value="<?= $user_profile['weight'] ?>" placeholder="体重"></div>
								<div class="col"><input type="text" class="form-control" id="age" value="<?= $user_profile['age'] ?>" placeholder="年齢"></div>
							</div>
							<div class="mt-2"><textarea class="form-control" id="description" rows="1" placeholder="ルームの一言メッセージ"></textarea></div>
							<div class="mt-3">
								<label class="form-label mb-0 small">チャットログ有効期間</label>
								<div class="d-flex flex-wrap column-gap-3 row-gap-1">
									<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="expire_0" value="0" <?= ($user_profile['log_expire_days'] == '0') ? 'checked' : '' ?>><label class="form-check-label small" for="expire_0">退室時に削除</label></div>
									<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="expire_1" value="1" <?= ($user_profile['log_expire_days'] == '1') ? 'checked' : '' ?>><label class="form-check-label small" for="expire_1">1日後に削除</label></div>
									<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="expire_7" value="7" <?= ($user_profile['log_expire_days'] == '7') ? 'checked' : '' ?>><label class="form-check-label small" for="expire_7">7日後に削除</label></div>
									<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="expire_m1" value="-1" <?= ($user_profile['log_expire_days'] == '-1') ? 'checked' : '' ?>><label class="form-check-label small" for="expire_m1">削除しない</label></div>
								</div>
							</div>
							<div class="my-3"><label class="form-label small">自分</label><div id="taste-checkboxes"><?php foreach ($tastes as $item): ?><div class="form-check form-check-inline"><input class="form-check-input taste-check" type="checkbox" value="<?= h($item) ?>" id="taste_<?= h($item) ?>" <?= in_array($item, $user_profile['tastes']) ? 'checked' : '' ?>><label class="form-check-label" for="taste_<?= h($item) ?>"><?= h($item) ?></label></div><?php endforeach; ?></div></div>
							<div class="my-3"><label class="form-label small">希望の相手 <a class="ms-2" data-bs-toggle="collapse" href="#wantCollapseContainer" role="button">(開閉)</a></label><div class="collapse" id="wantCollapseContainer"><div id="want-checkboxes"><?php foreach ($wants as $item): ?><div class="form-check form-check-inline"><input class="form-check-input want-check" type="checkbox" value="<?= h($item) ?>" id="want_<?= h($item) ?>" <?= in_array($item, $user_profile['wants']) ? 'checked' : '' ?>><label class="form-check-label" for="want_<?= h($item) ?>"><?= h($item) ?></label></div><?php endforeach; ?></div></div></div>
							<div class="my-3"><label class="form-label small">何が好き？ <a class="ms-2" data-bs-toggle="collapse" href="#hopeCollapseContainer" role="button">(開閉)</a><span class="text-muted ms-2">ちゃんとチェック付けた方がいいよ！</span></label><div class="collapse" id="hopeCollapseContainer"><div id="hope-checkboxes"><?php foreach ($hopes as $item): ?><div class="form-check form-check-inline"><input class="form-check-input hope-check" type="checkbox" value="<?= h($item) ?>" id="hope_<?= h($item) ?>" <?= in_array($item, $user_profile['hopes']) ? 'checked' : '' ?>><label class="form-check-label" for="hope_<?= h($item) ?>"><?= h($item) ?></label></div><?php endforeach; ?></div></div></div>
							<div class="d-flex flex-wrap align-items-center column-gap-3 row-gap-0 mt-2">
								<div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" value="1" id="flag_meet" <?= ($user_profile['flag_meet'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="flag_meet"><?= ICON_MEET ?> 待ち合わせ</label></div>
								<div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" value="1" id="flag_chatplay" <?= ($user_profile['flag_chatplay'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="flag_chatplay"><?= ICON_CHATPLAY ?> イメチャ</label></div>
								<div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" value="1" id="flag_onlyreal" <?= ($user_profile['flag_onlyreal'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="flag_onlyreal"><?= ICON_ONLYREAL ?> リアルのみ</label></div>
								<div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" value="1" id="flag_friend" <?= ($user_profile['flag_friend'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="flag_friend"><?= ICON_FRIEND ?> 彼氏彼女募集</label></div>
							</div>
							<?php if (!empty($system_message_raw)): ?><div class="alert alert-info mt-3 p-2" role="alert"><?= $system_message_raw; ?></div><?php endif; ?>
							<div class="d-flex justify-content-between align-items-center my-3">
								<label class="form-label mb-0">② 参加するルームを選択</label>
								<button type="button" id="refresh-room-list" class="btn btn-sm btn-outline-secondary"><i class="bi bi-arrow-clockwise"></i><span> 最新表示</span></button>
							</div>
							<div class="mb-3">
								 <ul id="room-list-container" class="list-group list-group-flush"></ul>
							</div>
							<hr>
							<label class="form-label">または、新しいルームを作成</label>
							<div id="new-room-controls">
								<div class="input-group">
									<input type="text" class="form-control" id="new_room_name_input" placeholder="新しいルーム名" required>
									<button type="button" id="create-room-btn" class="btn btn-success btn-no-wrap"><i class="bi bi-plus-circle-fill"></i> 作成して入室</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<form id="join-room-form" action="login.php" method="post" style="display: none;">
		<?= csrf_token_field() ?>
		<input type="hidden" name="room_id">
		<input type="hidden" name="new_room_name">
		<input type="hidden" name="user_name">
		<input type="hidden" name="usertype">
		<input type="hidden" name="height">
		<input type="hidden" name="weight">
		<input type="hidden" name="age">
		<input type="hidden" name="areaname">
		<input type="hidden" name="description">
		<input type="hidden" name="tastes">
		<input type="hidden" name="wants">
		<input type="hidden" name="hopes">
		<input type="hidden" name="beep_enabled">
		<input type="hidden" name="delete_logs_on_logout">
		<input type="hidden" name="log_expire_days">
		<input type="hidden" name="is_spectator">
		<input type="hidden" name="flag_meet" value="0">
		<input type="hidden" name="flag_chatplay" value="0">
		<input type="hidden" name="flag_onlyreal" value="0">
		<input type="hidden" name="flag_friend" value="0">
	</form>
	<input type="hidden" id="default-icon-filename" value="<?= h(DEFAULT_ICON_FILENAME) ?>">
	
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="assets/js/index.js?v=<?php echo time(); ?>"></script>
	
	<div id="icon-templates" style="display: none;">
		<span id="icon-meet"><?= ICON_MEET ?></span>
		<span id="icon-chatplay"><?= ICON_CHATPLAY ?></span>
		<span id="icon-onlyreal"><?= ICON_ONLYREAL ?></span>
		<span id="icon-friend"><?= ICON_FRIEND ?></span>
		<span id="icon-mobile"><i class="bi bi-phone"></i></span>
		<span id="icon-tablet"><i class="bi bi-tablet"></i></span>
		<span id="badge-new"><?= NEW_BADGE_HTML ?></span>
	</div>
</body>
</html>