<?php

// FILE: get_rooms.php (PRODUCTION READY - Logic reverted)
header('Content-Type: application/json; charset=utf-8');

date_default_timezone_set('Asia/Tokyo');

require_once __DIR__ . '/config.php';
session_start(['cookie_samesite' => 'None', 'cookie_secure' => true, 'cookie_httponly' => true]);
require_once __DIR__ . '/functions.php';
require_once __DIR__ . '/db.php';

generate_csrf_token();
$csrf_token = $_SESSION['csrf_token'] ?? '';
session_write_close();

// --- キャッシュ機能は無効化 ---
/*
$cache_dir = __DIR__ . '/cache';
$cache_file = $cache_dir . '/room_list_cache.json';
$cache_life = defined('ROOM_LIST_CACHE_SECONDS') ? ROOM_LIST_CACHE_SECONDS : 5;
if (!is_dir($cache_dir)) { @mkdir($cache_dir, 0755, true); }
if (file_exists($cache_file) && is_writable($cache_file) && (time() - filemtime($cache_file)) < $cache_life) {
    $cache_content = file_get_contents($cache_file);
    $data = json_decode($cache_content, true);
    if ($data && isset($data['status']) && $data['status'] === 'success') {
        $data['csrf_token'] = $csrf_token;
        echo json_encode($data, JSON_UNESCAPED_UNICODE);
        exit;
    }
}
*/
ob_start();

try {
    $pdo = get_pdo();

    // === メンテナンス処理 ===
    if (rand(1, MAINTENANCE_PROBABILITY) === 1) {
        run_maintenance($pdo);
    }

    // === ステップ1: 全てのルーム情報を取得 ===
    $stmt_rooms = $pdo->prepare("
		SELECT 
			room_id, room_name, is_locked, description,
			created_by, roomgroup, roomcolor, roomsort,
			flag_meet, flag_chatplay, flag_onlyreal, flag_friend,
			updated_at AS updated_at_utc,
			started_at
		FROM chat_rooms
		ORDER BY roomgroup ASC, roomsort ASC, room_name ASC
	");
    $stmt_rooms->execute();
    $rooms_array = $stmt_rooms->fetchAll(PDO::FETCH_ASSOC);

    $rooms_by_id = [];
    foreach ($rooms_array as $room) {
        $room['members_data'] = [];
        $room['member_count'] = 0;
        $rooms_by_id[$room['room_id']] = $room;
    }

    // === ステップ2: オンラインの全ユーザー情報を取得 ===
    $stmt_users = $pdo->prepare("
		SELECT
			os.room_id,
			u.user_id, u.user_name, u.icon_image, u.is_spectator, u.device_type,
			u.height, u.weight, u.age, u.usertype, u.areaname,
			u.tastes, u.wants, u.hopes,
			u.flag_meet, u.flag_chatplay, u.flag_onlyreal, u.flag_friend,
			ut.typecolor,
			:area_color AS area_color
		FROM online_status os
		LEFT JOIN users3 u ON os.user_id = u.user_id
		LEFT JOIN usertype ut ON u.usertype = ut.usertype
		WHERE u.deny = 0
	");
    $stmt_users->execute([':area_color' => defined('AREA_NAME_COLOR') ? AREA_NAME_COLOR : 'royalblue']);
    $online_users = $stmt_users->fetchAll(PDO::FETCH_ASSOC);

    // === ステップ3: ユーザーを各ルームに割り当てる ===
    foreach ($online_users as $user) {
        $room_id = $user['room_id'];
        if (isset($rooms_by_id[$room_id])) {
            $rooms_by_id[$room_id]['members_data'][] = $user;
            $rooms_by_id[$room_id]['member_count']++;
        }
    }

    // === ステップ4: 参加者の並び順を調整 ===
    foreach ($rooms_by_id as &$room) {
        if ($room['member_count'] > 1) {
            usort($room['members_data'], function ($a, $b) use ($room) {
                if ($a['user_id'] == $room['created_by']) {
                    return -1;
                }
                if ($b['user_id'] == $room['created_by']) {
                    return 1;
                }
                // 入室順のデータがないため、ユーザーIDでソート
                return (int)$a['user_id'] - (int)$b['user_id'];
            });
        }
    }
    unset($room);

    $rooms = array_values($rooms_by_id);

    // === ステップ5: 最終的なフラグを判定 (UNIXタイムスタンプ使用) ===
    $now_ts = time();
    $recent_activity_threshold_ts = $now_ts - 300;
    $new_badge_threshold_ts = $now_ts - (NEW_BADGE_MINUTES * 60);

    foreach ($rooms as &$room) {
        $is_active = false;
        if ($room['member_count'] > 0 && !empty($room['updated_at_utc'])) {
            $updated_at_ts = strtotime($room['updated_at_utc']);
            if ($updated_at_ts !== false && $updated_at_ts > $recent_activity_threshold_ts) {
                $is_active = true;
            }
        }
        $room['is_recently_active'] = $is_active;

        $room['is_new'] = false;
        if (!$room['is_locked'] && $room['member_count'] > 0 && !empty($room['started_at'])) {
            $started_at_ts = strtotime($room['started_at']);
            if ($started_at_ts !== false && $started_at_ts > $new_badge_threshold_ts) {
                $room['is_new'] = true;
            }
        }

        $room['elapsed_time_str'] = '';
        if ($room['member_count'] > 0 && !empty($room['started_at'])) {
            $started_at_ts = strtotime($room['started_at']);
            if ($started_at_ts !== false) {
                $elapsed_seconds = $now_ts - $started_at_ts;
                if ($elapsed_seconds < 0) {
                    $elapsed_seconds = 0;
                }
                $elapsed_minutes = floor($elapsed_seconds / 60);
                $room['elapsed_time_str'] = $elapsed_minutes . '分';
            }
        }
    }
    unset($room);

    $response = ['status' => 'success', 'rooms' => $rooms, 'csrf_token' => $csrf_token];
} catch (Throwable $e) {
    header("HTTP/1.1 500 Internal Server Error", true, 500);
    $response = ['status' => 'error', 'message' => 'An internal server error occurred.'];
    error_log("get_rooms.php failed: " . $e->getMessage() . " TRACE: " . $e->getTraceAsString());
}

$output = json_encode($response, JSON_UNESCAPED_UNICODE);

if ($output === false) {
    header("HTTP/1.1 500 Internal Server Error", true, 500);
    $response = ['status' => 'error', 'message' => 'Failed to encode JSON response.','json_error' => json_last_error_msg()];
    $output = json_encode($response);
}

// --- キャッシュ書き込みは無効化 ---
/*
$cache_dir_write = __DIR__ . '/cache';
$cache_file_write = $cache_dir_write . '/room_list_cache.json';
if (is_writable($cache_dir_write)) {
    @file_put_contents($cache_file_write, $output, LOCK_EX);
}
*/

ob_end_flush();
echo $output;
exit;
