<?php

// FILE: config.php
// データベース設定
    define('DB_HOST', 'localhost');
    define('DB_NAME', 'chat');
    define('DB_USER', 'user');
    define('DB_PASS', 'password');
    define('SITE_NAME', 'チャット');

// タイムゾーン設定
date_default_timezone_set('Asia/Tokyo');
// Cookie名
define('COOKIE_NAME', 'chat_unique_id');
// オンラインと判断する秒数 (ユーザーリスト更新間隔より少し長めに設定)
define('ONLINE_THRESHOLD_SECONDS', 15);

// ルーム一覧取得時のメンテナンス実行確率 (N回に1回)
define('MAINTENANCE_PROBABILITY', 1); // 5回に1回の確率で実行

// ルーム一覧のキャッシュを有効にするか (true: 有効, false: 無効)
define('ENABLE_ROOM_LIST_CACHE', false);

// 自動退室とみなす秒数 (3分)
define('AUTO_LOGOUT_SECONDS', 180);
// 強制退室させられたユーザーを自動で解除する分数
define('RESET_DENY_MINUTE', 5);
// ルーム作成者がこの秒数アクセスしないとルームを閉鎖する
define('CREATOR_INACTIVITY_CLOSE_SECONDS', 60*60*24); // 24時間
// アップロード画像の最大幅
define('MAX_IMAGE_WIDTH', 800);
// ルーム一覧ページの自動更新頻度（秒単位）
define('ROOM_LIST_REFRESH_SECONDS', 30);
define('UPLOAD_FILE_EXPIRE_DAYS', 7);
define('DEFAULT_ICON_FILENAME', 'default_icon.png');
// ブラウザを閉じた際の自動退室ログを有効にするか (true: 有効, false: 無効)
define('ENABLE_AUTO_LEAVE_LOG', true);
// システムメッセージ（入退室ログなど）が自動で消えるまでの秒数 (60 = 1分)
define('SYSTEM_MESSAGE_EXPIRE_SECONDS', 60);
// オフラインユーザーのメッセージ背景色
define('MESSAGE_BG_OFFLINE', '#404040');

// チャットルーム内のポーリング間隔
define('CHAT_POLLING_INTERVAL_MS', 1000 * 20); // 20秒 (チャットログ)
define('USERS_POLLING_INTERVAL_MS', 1000 * 10); // 10秒 (参加者リスト)

// タイピング中通知機能（「入力中...」の表示）を有効にするか
define('ENABLE_TYPING_NOTIFICATION', true);

// プロフィール画像の最大高さ
define('MAX_PROFILE_IMAGE_HEIGHT', 128);
// プロフィール画像の最大幅
define('MAX_PROFILE_IMAGE_WIDTH', 128);

// エラーをすべて表示する (開発時のみ)
@ini_set('display_errors', 1);
error_reporting(E_ALL);
// POSTデータの上限を12MBに設定
@ini_set('post_max_size', '12M');
@ini_set('upload_max_filesize', '10M');
@ini_set('memory_limit', '128M');
define('AREA_NAME_COLOR', 'chocolate');
// 目的フラグアイコンの色定義
define('ICON_COLOR_MEET', 'text-success');
define('ICON_COLOR_CHATPLAY', 'text-warning');
define('ICON_COLOR_ONLYREAL', 'text-danger');
define('ICON_COLOR_FRIEND', 'text-danger');
define('ICON_COLOR_SPECTATOR', 'text-blueviolet');
// 目的フラグアイコンのHTML定義（色情報を含む）
define('ICON_MEET', '<i class="bi bi-cup-hot-fill ' . ICON_COLOR_MEET . '" title="待ち合わせ"></i>');
define('ICON_CHATPLAY', '<i class="bi bi-keyboard ' . ICON_COLOR_CHATPLAY . '" title="イメチャ"></i>');
define('ICON_ONLYREAL', '<i class="bi bi-geo-alt-fill ' . ICON_COLOR_ONLYREAL . '" title="リアルのみ"></i>');
define('ICON_FRIEND', '<i class="bi bi-arrow-through-heart-fill ' . ICON_COLOR_FRIEND . '" title="彼氏募集"></i>');
define('ICON_SPECTATOR', '<i class="bi bi-incognito ' . ICON_COLOR_SPECTATOR . '" title="覗き見"></i>');

define('MATCHED_HOPE_COLOR', 'Magenta');
define('NEW_BADGE_MINUTES', 15);
// NEWバッジのHTML
define('NEW_BADGE_HTML', '<span class="badge bg-warning text-dark me-1">NEW</span>');

// ★★★★★★★★★★★★★★★★★★★★ 追加箇所 ★★★★★★★★★★★★★★★★★★★★
// ルーム一覧の背景色
define('ROOM_BG_AVAILABLE', '#003333'); // 参加者がいて入室可能な部屋 Billiard Green
define('ROOM_BG_LOCKED', '#330033');      // 入室制限中の部屋
define('ENABLE_AUTO_LINK', true);			// URLを自動的にリンクに変換するか (true: 有効, false: 無効)
