// FILE: assets/js/chat.js (ULTIMATE FINAL - VERIFIED NO OMISSION - FULLY FORMATTED)
document.addEventListener('DOMContentLoaded', function() {

	// ===================================================================
	//  1. 変数定義と初期化
	// ===================================================================
	const AJAX_URL = $('#ajax-url').val();
	const MY_USER_ID = parseInt($('#user_id').val(), 10);
	const ROOM_ID = $('#room_id').val();
	const ROOM_NAME = $('#room_name_hidden').val();
	const ENABLE_AUTO_LINK = parseInt($('#enable_auto_link').val(), 10) === 1;
	let isTyping = false,
		isComposing = false,
		typingTimer;
	let currentUserBeepEnabled = false;
	let currentSpectatorCount = 0;
	let isRoomLocked = false;
	let privateMessageModal, profileModal;
	const chatLogContainer = $('#chat-log');
	const notificationArea = $('#system-notification-area');
	let $lightboxOverlay, $lightboxContainer, $lightboxImage, $reportBtn;
	let scale = 1,
		isDragging = false,
		startX, startY;
	let isResizing = false,
		resizeStartX, resizeStartY, startWidth, startHeight;
	const openedProfileMessages = new Set();
	const ICON_HTML = {
		meet: $('#icon-meet').html(),
		chatplay: $('#icon-chatplay').html(),
		onlyreal: $('#icon-onlyreal').html(),
		friend: $('#icon-friend').html(),
		mobile: $('#icon-mobile').html(),
		tablet: $('#icon-tablet').html()
	};
	let isLeaveHandlerExecuted = false;
	let lastUserListTimestamp = '0';

	const handlePageLeave = () => {
		if (isLeaveHandlerExecuted) { return; }
		isLeaveHandlerExecuted = true;
		if (navigator.sendBeacon) {
			const data = JSON.stringify({
				user_id: MY_USER_ID,
				room_id: ROOM_ID,
				user_name: $('#user_name_hidden').val()
			});
			navigator.sendBeacon('leave_room.php', new Blob([data], { type: 'application/json' }));
		}
	};

	init();

	// ===================================================================
	//  2. 初期化関数
	// ===================================================================
	function init() {
		privateMessageModal = new bootstrap.Modal(document.getElementById('privateMessageModal'));
		profileModal = new bootstrap.Modal(document.getElementById('profileModal'));
		initLightbox();
		bindEventHandlers();
		startPollingMessages();
		startPollingUsersAndRoomStatus();
	}

	function startPollingMessages() {
		const interval = parseInt($('#chat_polling_interval').val(), 10) || 3000;
		fetchMessages();
		setInterval(fetchMessages, interval);
	}

	function startPollingUsersAndRoomStatus() {
		const interval = parseInt($('#users_polling_interval').val(), 10) || 10000;
		fetchUsersAndRoomStatus();
		setInterval(fetchUsersAndRoomStatus, interval);
	}

	// ===================================================================
	//  3. データ取得 (Ajax)
	// ===================================================================
	function fetchMessages() {
		$.ajax({
			url: AJAX_URL, type: 'GET', dataType: 'json',
			data: { action: 'get_messages', room_id: ROOM_ID, last_log_id: $('#last_log_id').val() }
		}).done(data => {
			if (data.status !== 'success') return;
			if (data.csrf_token) { $('#csrf-token-for-ajax').val(data.csrf_token); }
			if (data.user_list_timestamp && data.user_list_timestamp !== lastUserListTimestamp) {
				fetchUsersAndRoomStatus();
				lastUserListTimestamp = data.user_list_timestamp;
			}
			if (Array.isArray(data.deleted_ids) && data.deleted_ids.length > 0) { removeDeletedMessages(data.deleted_ids); }
			if (Array.isArray(data.messages) && data.messages.length > 0) {
				const hasNewUserMessage = data.messages.some(msg => parseInt(msg.is_system, 10) === 0);
				if (hasNewUserMessage) { fetchUsersAndRoomStatus(); }
				const shouldPlayBeep = data.messages.some(msg => parseInt(msg.is_system, 10) === 1 || (msg.user_id != MY_USER_ID));
				renderMessages(data.messages);
				currentUserBeepEnabled = (data.beep_enabled === 1);
				if (shouldPlayBeep && currentUserBeepEnabled) { playBeep(); }
			}
			if (chatLogContainer.find('.chat-message').length === 0) { $('#initial-message').show(); } else { $('#initial-message').hide(); }
		}).fail(handleAjaxError);
	}

	function fetchUsersAndRoomStatus() {
		$.ajax({
			url: AJAX_URL, type: 'GET', dataType: 'json',
			data: { action: 'get_users_and_room_status', room_id: ROOM_ID }
		}).done(data => {
			if (data.status !== 'success') return;
			let kickOut = false, alertMessage = '';
			if (data.is_denied) { kickOut = true; alertMessage = 'このチャットルームは利用できません'; } 
			else if (data.room_closed) { kickOut = true; alertMessage = '参加者がいなくなったため、チャットルームは閉鎖されました。'; }
			if (kickOut) { alert(alertMessage); window.location.href = 'logout.php'; return; }
			$('#initial-loading').hide();
			isRoomLocked = data.is_locked == 1;
			currentSpectatorCount = data.spectator_count || 0;
			updateRoomUI(data);
			if (Array.isArray(data.users)) { renderUsers(data.users); }
		}).fail(handleAjaxError);
	}

	function handleAjaxError(jqXHR, textStatus, errorThrown) {
		console.error('Failed to fetch data.', textStatus, errorThrown, jqXHR.responseText);
		if (jqXHR.status === 401 || jqXHR.status === 403) {
			const res = jqXHR.responseJSON;
			if (res && res.message) {
				alert('エラー: ' + res.message);
				if(res.new_csrf_token) { $('#csrf-token-for-ajax').val(res.new_csrf_token); }
			} else {
				alert('セッションが切れました。ログインページに戻ります。');
				isLeaveHandlerExecuted = true; window.location.href = 'index.php';
			}
		} else if (jqXHR.status === 500) {
			const res = jqXHR.responseJSON;
			if (res && res.error_details && res.error_details.message) {
				alert(`サーバーエラーが発生しました。\n${res.error_details.message}`);
			} else {
				alert('サーバーで致命的なエラーが発生しました。');
			}
		} else if (textStatus === 'parsererror') { console.error('JSON Parse Error:', jqXHR.responseText); }
	}
	
	// ===================================================================
	//  4. イベントハンドラ
	// ===================================================================
	function bindEventHandlers() {
		$(document)
			.on('submit', '#message-form', handleFormSubmit)
			.on('change', '#file-input', handleFileSelect)
			.on('input keydown', '#message-input', handleTextareaInput)
			.on('compositionstart', '#message-input', () => { isComposing = true; }).on('compositionend', '#message-input', () => { isComposing = false; })
			.on('submit', '#private-message-form', sendPrivateMessage)
			.on('click', '#cancel-file-selection', () => { $('#file-input').val(''); $('#file-preview').empty(); })
			.on('click', '.delete-message-btn', handleDeleteMessage)
			.on('click', '.kick-user-btn', handleKickUser)
			.on('click', '#toggle-lock-btn', handleToggleLock)
			.on('click', '.private-message-btn', showPrivateMessageModal)
			.on('click', '.image-container a', showLightbox)
			.on('click', '.close-lightbox-btn', hideLightbox)
			.on('click', '.report-btn', reportImage)
			.on('click', '#zoom-in-btn', () => applyZoom(0.2)).on('click', '#zoom-out-btn', () => applyZoom(-0.2))
			.on('click', '.close-room-btn', handleCloseRoom);
		$(document).on('click', '#scroll-to-top-btn', function() { $('#chat-log').animate({ scrollTop: 0 }, 'slow'); });
		$(document).on('click', '#refresh-user-list-btn, #refresh-user-list-btn-offcanvas', fetchUsersAndRoomStatus);
		$('a[href="logout.php"]').on('click', function(e) {
			isLeaveHandlerExecuted = true; window.removeEventListener('pagehide', handlePageLeave, { capture: true });
		});
		const autoLeaveSetting = $('#auto_leave_on_close_setting').val();
		if (autoLeaveSetting === '1') { window.addEventListener('pagehide', handlePageLeave, { capture: true }); }
		window.addEventListener('pageshow', function(event) { if (event.persisted) { isLeaveHandlerExecuted = true; window.location.reload(); } });
		const profileModalEl = document.getElementById('profileModal');
		if (profileModalEl) { profileModalEl.addEventListener('show.bs.modal', function () { loadProfileForm(); });}
		$(document).on('submit', '#profile-update-form', function(e) { e.preventDefault(); updateProfile(); });
		$(document).on('change', '#prof-icon_image', function() {
			const file = this.files[0];
			if (file) {
				const reader = new FileReader();
				reader.onload = function(e) { $('#profile-icon-preview').attr('src', e.target.result); }
				reader.readAsDataURL(file);
			}
		});
	}
	
	// ===================================================================
	//  5. イベントハンドラから呼ばれる個別関数
	// ===================================================================
	function handleFormSubmit(e) { e.preventDefault(); postMessage(); }
	function handleDeleteMessage() { if (confirm('このメッセージを削除しますか？')) deleteMessage($(this).data('log-id')); }
	function handleKickUser(e) { e.stopPropagation(); const uid = $(this).data('user-id'), uname = $(this).data('user-name'); if (confirm(`${escapeHtml(uname)}さんを退室させますか？`)) kickUser(uid); }
	function showPrivateMessageModal() { const toUserId = $(this).data('user-id'), toUserName = $(this).data('user-name'); if (privateMessageModal) { $('#private-message-recipient').text(escapeHtml(toUserName) + ' さんへ送信'); $('#private-to-user-id').val(toUserId); $('#private-message-input').val('').focus(); privateMessageModal.show(); } }
	function handleTextareaInput(e) { this.style.height = 'auto'; this.style.height = (this.scrollHeight) + 'px'; if (e.type === 'input') { if (!isTyping) { isTyping = true; updateTypingStatus('typing'); } clearTimeout(typingTimer); typingTimer = setTimeout(() => { isTyping = false; updateTypingStatus('stopped'); }, 2000); } if (e.type === 'keydown' && e.key === 'Enter' && !e.shiftKey && !isComposing) { e.preventDefault(); $('#message-form').submit(); } }
	function handleFileSelect() { const file = this.files[0]; const previewArea = $('#file-preview'); if (!file) { previewArea.empty(); return; } if (file.size > 2097152) { alert('ファイルサイズが2MBを超えています。'); $(this).val(''); previewArea.empty(); return; } previewArea.html(`<div class="alert alert-info alert-dismissible fade show p-2 mt-2" role="alert"><i class="bi bi-file-earmark-arrow-up"></i><span class="ms-1 fw-bold">${escapeHtml(file.name)}</span><small class="text-muted ms-2">送信</small><button type="button" class="btn-close p-2" id="cancel-file-selection"></button></div>`); }
	function handleCloseRoom(e) { e.stopPropagation(); const button = $(this); const roomName = button.data('room-name'); const roomId = button.data('room-id'); if(confirm(`ルーム「${escapeHtml(roomName)}」を完全に閉鎖します。よろしいですか？`)){ const csrfToken = $('#csrf-token-for-ajax').val(); $.ajax({ url: AJAX_URL, type: 'POST', dataType: 'json', data: { action: 'close_room', room_id: roomId, csrf_token: csrfToken }}).done(data => { if(data && data.status === 'success'){ alert(data.message || `ルーム「${escapeHtml(roomName)}」を閉鎖しました。`); window.location.href = 'logout.php'; } else { alert('ルームの閉鎖に失敗しました: ' + (data.message || '不明なエラーです。')); }}).fail(handleAjaxError); } }
	
	// ===================================================================
	//  6. サーバー通信 (Ajax Actions)
	// ===================================================================
	function postMessage() { const messageInput = $('#message-input'); if (messageInput.val().trim() === '' && !$('#file-input')[0].files[0]) return; const formData = new FormData($('#message-form')[0]); formData.append('action', 'post_message'); formData.append('room_id', ROOM_ID); formData.append('csrf_token', $('#csrf-token-for-ajax').val()); $.ajax({ url: AJAX_URL, type: 'POST', data: formData, processData: false, contentType: false, dataType: 'json' }).done(data => { if (data.status === 'success') { if (data.system_message_data) { renderMessages([data.system_message_data]); } if (data.message_data) { renderMessages([data.message_data]); } $('#message-form')[0].reset(); $('#file-preview').empty(); messageInput.css('height', 'auto').focus(); } else { alert('メッセージの送信に失敗しました: ' + (data.message || '')); } }).fail(handleAjaxError); }
	function sendPrivateMessage(e) { e.preventDefault(); const message = $('#private-message-input').val(); if (message.trim() === '') return; const formData = new FormData(); formData.append('action', 'post_message'); formData.append('room_id', ROOM_ID); formData.append('message', message); formData.append('to_user_id', $('#private-to-user-id').val()); formData.append('csrf_token', $('#csrf-token-for-ajax').val()); $.ajax({ url: AJAX_URL, type: 'POST', data: formData, processData: false, contentType: false, dataType: 'json' }).done(data => { if (data.status === 'success' && data.message_data) { renderMessages([data.message_data]); privateMessageModal.hide(); } else { alert('メッセージの送信に失敗しました: ' + (data.message || ''));} }).fail(handleAjaxError); }
	function updateTypingStatus(status) { $.ajax({ url: AJAX_URL, type: 'POST', data: { action: 'update_typing', room_id: ROOM_ID, status: status, csrf_token: $('#csrf-token-for-ajax').val() } }); }
	function deleteMessage(logId) { $.ajax({ url: AJAX_URL, type: 'POST', dataType: 'json', data: { action: 'delete_message', log_id: logId, csrf_token: $('#csrf-token-for-ajax').val() }}).done(data => { if (data.status === 'success') { $(`#log-${logId}`).fadeOut(300, function() { $(this).remove(); }); } else { alert('メッセージの削除に失敗しました: ' + (data.message || '')); } }).fail(handleAjaxError); }
	function kickUser(targetUserId) { $.ajax({ url: AJAX_URL, type: 'POST', dataType: 'json', data: { action: 'kick_user', room_id: ROOM_ID, target_user_id: targetUserId, csrf_token: $('#csrf-token-for-ajax').val() }}).done(data => { if (data.status !== 'success') { alert('ユーザーの退室処理に失敗しました: ' + (data.message || '')); } }).fail(handleAjaxError); }
	function handleToggleLock() { if (currentSpectatorCount > 0) { alert('覗き見しているユーザーがいるため、入室制限はできません。'); return; } const currentLockStatus = isRoomLocked; const newLockStatus = !currentLockStatus; isRoomLocked = newLockStatus; updateRoomUI({ is_locked: newLockStatus }); const lockButton = $('#toggle-lock-btn'); if (lockButton.length > 0) { const lockBtnClass = newLockStatus ? 'btn-warning' : 'btn-outline-warning'; const lockBtnIcon = newLockStatus ? 'bi-unlock-fill' : 'bi-lock-fill'; const lockBtnText = newLockStatus ? 'オープン' : '入室制限'; lockButton.removeClass('btn-warning btn-outline-warning').addClass(lockBtnClass); lockButton.find('i').removeClass('bi-unlock-fill bi-lock-fill').addClass(lockBtnIcon); lockButton.contents().filter(function() { return this.nodeType === 3; }).last().replaceWith(` ${lockBtnText}`); } $.ajax({ url: AJAX_URL, type: 'POST', dataType: 'json', data: { action: 'toggle_room_lock', room_id: ROOM_ID, csrf_token: $('#csrf-token-for-ajax').val() }}).done(data => { if (data.status === 'success' && data.is_locked == newLockStatus) { fetchUsersAndRoomStatus(); } else { isRoomLocked = currentLockStatus; updateRoomUI({ is_locked: currentLockStatus }); alert(data.message || '操作に失敗しました。'); fetchUsersAndRoomStatus(); } }).fail(() => { isRoomLocked = currentLockStatus; updateRoomUI({ is_locked: currentLockStatus }); alert(newLockStatus ? '入室制限の設定ができませんでした' : '入室制限を解除できませんでした'); fetchUsersAndRoomStatus(); }); }
	function reportImage() { if (!confirm('この画像を不適切なコンテンツとして管理者に通報しますか？\n通報された画像はチャットから削除されます。')) return; const logId = $reportBtn.data('log-id'); const $targetImageContainer = $reportBtn.data('target-image-container'); $.ajax({ url: AJAX_URL, type: 'POST', dataType: 'json', data: { action: 'report_image', log_id: logId, csrf_token: $('#csrf-token-for-ajax').val() }}).done(data => { if (data.status === 'success') { alert('管理者に通報しました。ご協力ありがとうございます。'); hideLightbox(); $targetImageContainer.remove(); const $messageBubble = $(`#log-${logId}`).find('.message-bubble'); const existingHtml = $messageBubble.html().replace(/<div class="image-container".*?<\/div>/, '').trim(); let newText = '（画像は通報により削除されました）'; if (existingHtml) { newText = existingHtml + '<br>' + newText; } $messageBubble.html(newText); } else { alert('エラー: ' + (data.message || '通報に失敗しました。')); } }).fail(handleAjaxError); }
	function updateProfile() { const form = $('#profile-update-form'); const formData = new FormData(form[0]); const statusArea = $('#profile-update-status'); const submitButton = form.find('button[type="submit"]'); submitButton.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> 更新中...'); statusArea.text('');formData.append('action', 'update_profile'); formData.append('csrf_token', $('#csrf-token-for-ajax').val()); $.ajax({ url: AJAX_URL, type: 'POST', data: formData, processData: false, contentType: false, dataType: 'json' }).done(function(response) { if (response.status === 'success') { statusArea.text(response.message).removeClass('text-danger').addClass('text-success'); $('.navbar-text .d-none.d-sm-inline').text(response.new_user_name); $('#user_name_hidden').val(response.new_user_name); fetchUsersAndRoomStatus(); setTimeout(function() { profileModal.hide(); }, 1500); } else { statusArea.text(response.message || '更新に失敗しました。').removeClass('text-success').addClass('text-danger'); } }).fail(handleAjaxError).always(function() { submitButton.prop('disabled', false).text('更新'); }); }
	
	// ===================================================================
		//  7. DOM操作・描画
		// ===================================================================
		function showSystemNotification(message, timestamp) {
			const existingMessages = notificationArea.find('.system-notification-message');
			if (existingMessages.length >= 2) {
				existingMessages.last().remove();
			}
			existingMessages.removeClass('is-new').addClass('is-old');
			const fullMessage = `<small class="text-muted me-2">${timestamp}</small> ${message}`;
			const $newMessage = $(`<div class="system-notification-message is-new is-highlighted">${fullMessage}</div>`);
			notificationArea.prepend($newMessage);
			setTimeout(() => { $newMessage.addClass('is-visible'); }, 10);
			const expireSeconds = parseInt($('#system_message_expire_seconds').val(), 10) || 60;
			setTimeout(() => { $newMessage.removeClass('is-highlighted'); }, 5000);
			setTimeout(() => {
				$newMessage.removeClass('is-visible');
				setTimeout(() => { $newMessage.remove(); }, 500);
			}, expireSeconds * 1000);
		}

		function makeLinksClickableJs(text) {
			let escapedText = escapeHtml(text);
			if (ENABLE_AUTO_LINK) {
				const urlPattern = /(https?:\/\/[^\s<>"'()]+)/g;
				escapedText = escapedText.replace(urlPattern, '<a href="$1" target="_blank" rel="noopener noreferrer">$1</a>');
			}
			return escapedText.replace(/\n/g, '<br>');
		}
		
		function renderMessages(messages) {
			const wasScrolledToBottom = isScrolledToBottom();
			messages.forEach(msg => {
				if (!msg || !msg.log_id) return;
				if (parseInt($('#last_log_id').val(), 10) < msg.log_id) {
					$('#last_log_id').val(msg.log_id);
				}
				if (parseInt(msg.is_system, 10)) {
					showSystemNotification(escapeHtml(msg.message), escapeHtml(msg.created_at));
				} else {
					if ($(`#log-${msg.log_id}`).length) return;
					const isSelf = msg.user_id == MY_USER_ID;
					const messageSide = isSelf ? 'self' : 'other';
					let bubbleClass = messageSide;
					if (!isSelf && !parseInt(msg.is_online, 10)) {
						bubbleClass += ' offline';
					}
					const nameAlign = isSelf ? 'text-end' : 'text-start';
					let profileHtml = '';
					const physicalData = [msg.height, msg.weight, msg.age].filter(p => p).join('/');
					let typeHtml = (msg.usertype && msg.typecolor) ? `<span style="color: ${escapeHtml(msg.typecolor)}; font-weight: bold;">${escapeHtml(msg.usertype)}</span>` : '';
					const profileParts = [typeHtml, escapeHtml(physicalData)].filter(p => p);
					if (profileParts.length > 0) profileHtml = ` <small class="text-muted">(${profileParts.join(' ')})</small>`;
					const userNameStyle = (msg.typecolor && !isSelf) ? `style="color: ${escapeHtml(msg.typecolor)};"` : '';
					const userNameHtml = `<strong ${userNameStyle}>${escapeHtml(msg.user_name)}</strong>`;
					let fileHtml = '', isNewImage = false;
					if (msg.file_path && /\.(jpg|jpeg|png|gif)$/i.test(msg.file_name)) {
						isNewImage = true;
						fileHtml = `<div class="image-container"><a href="${escapeHtml(msg.file_path)}" target="_blank"><img src="${escapeHtml(msg.file_path)}" class="message-image new-image-fadein" alt="${escapeHtml(msg.original_file_name)}"></a><small class="image-caption bg-light text-dark px-1 rounded">クリックして拡大</small></div>`;
					} else if (msg.file_path) {
						fileHtml = `<a href="${escapeHtml(msg.file_path)}" target="_blank" class="message-file-link"><i class="bi bi-file-earmark-arrow-down"></i> ${escapeHtml(msg.original_file_name)}</a>`;
					}
					const privateTag = msg.is_private ? (isSelf ? `<span class="badge bg-info">To: ${escapeHtml(msg.to_user_name)}</span> ` : `<span class="badge bg-info">From: ${escapeHtml(msg.user_name)}</span> `) : '';
					const deleteBtnHtml = isSelf ? `<div class="flex-shrink-0 ms-2 align-self-end"><span class="delete-message-btn" data-log-id="${msg.log_id}"><i class="bi bi-x-circle"></i></span></div>` : '';
					const messageTextHtml = msg.message ? makeLinksClickableJs(msg.message) : '';
					const messageBubbleHtml = `<div class="message-bubble ${bubbleClass}">${privateTag}${messageTextHtml}${fileHtml ? `<div class="mt-1">${fileHtml}</div>` : ''}</div>`;
					const messageHtml = `<div id="log-${msg.log_id}" class="chat-message ${messageSide} new-message" data-user-id="${msg.user_id}"><div class="${nameAlign} message-meta"><img src="uploads/${escapeHtml(msg.icon_image || 'default_icon.png')}" class="rounded-0 me-1" style="width: 20px; height: 20px; object-fit: cover; vertical-align: middle;">${userNameHtml}${profileHtml}<small class="text-muted ms-2">${escapeHtml(msg.created_at)}</small></div><div class="d-flex ${isSelf ? 'justify-content-end' : 'justify-content-start'}">${isSelf ? messageBubbleHtml + deleteBtnHtml : messageBubbleHtml}</div></div>`;
					chatLogContainer.append(messageHtml);
					const $newMessageElement = $(`#log-${msg.log_id}`);
					if (!isSelf) { setTimeout(() => { $newMessageElement.removeClass('new-message'); }, 5000); }
					if (isNewImage) { const $image = $(`#log-${msg.log_id}`).find('.message-image'); setTimeout(() => { $image.addClass('visible'); }, 50); setTimeout(() => { $image.removeClass('new-image-fadein visible'); }, 700); }
				}
			});
			if (wasScrolledToBottom) { scrollToBottom(); }
		}
		function renderUsers(users) {
			const iAmCreator = users.find(u => u.user_id === MY_USER_ID && u.is_creator);
		
			const userListHtml = users.map(user => {
				if (!user) return '';
				
				const isFormallySpectator = parseInt(user.is_spectator, 10) === 1;
				const hasPostedMessage = parseInt(user.message_cnt, 10) > 0;
				let finalUserName = escapeHtml(user.user_name);
				let spectatorIcon = '';
		
				if ((isFormallySpectator || !hasPostedMessage) && user.user_id != MY_USER_ID) {
					spectatorIcon = `<i class="bi bi-incognito me-1" title="覗き見中または未発言" style="color: Blueviolet;"></i>`;
				}
				if (isFormallySpectator && user.user_id != MY_USER_ID) {
					finalUserName = '******';
				}
				
				const creatorIcon = user.is_creator ? `<i class="bi bi-person-vcard-fill text-warning me-1" title="ルーム管理者"></i>` : '';
				const deviceIcon = user.device_type === 'Mobile' ? ` <span title="モバイル">${ICON_HTML.mobile}</span>` : (user.device_type === 'Tablet' ? ` <span title="タブレット">${ICON_HTML.tablet}</span>` : '');
				const lastActiveTime = user.last_active_str ? `<span class="text-info ms-2">[${user.last_active_str.split(' ')[1]}]</span>` : '';
				const userNameHtml = `<div class="fw-bold text-truncate">${creatorIcon}${spectatorIcon}${finalUserName}${deviceIcon}</div>`;
				
				let profileParts = [];
				if (lastActiveTime) profileParts.push(lastActiveTime);
				if (user.usertype && user.typecolor) { profileParts.push(`<span style="color: ${escapeHtml(user.typecolor)}; font-weight: bold;">${escapeHtml(user.usertype)}</span>`); }
				const physicalData = [user.height, user.weight, user.age].filter(p => p).join('/');
				if (physicalData) { profileParts.push(escapeHtml(physicalData)); }
				if (user.areaname) { profileParts.push(`<span style="color: ${escapeHtml(user.area_color)};">${escapeHtml(user.areaname)}</span>`); }
				
				let userFlagIconsHtml = '';
				if (parseInt(user.flag_meet, 10)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.meet}</span>`;
				if (parseInt(user.flag_chatplay, 10)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.chatplay}</span>`;
				if (parseInt(user.flag_onlyreal, 10)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.onlyreal}</span>`;
				if (parseInt(user.flag_friend, 10)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.friend}</span>`;
		
				const profilePartsHtml = profileParts.join(' ');
				let profileText = (profilePartsHtml.trim() || userFlagIconsHtml.trim()) ? `<div class="small text-muted" style="line-height: 1.2;">${profilePartsHtml}${userFlagIconsHtml}</div>` : '';
				
				// ▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼ 以下のブロックを修正 ▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼▼
				let tastesHtml = '';
				if (user.tastes) {
					tastesHtml = `<div class="mt-1 d-flex flex-wrap">${user.tastes.split(',').map(item => item ? `<span class="badge bg-secondary me-1 mb-1">${escapeHtml(item)}</span>` : '' ).join('')}</div>`;
				}
				
				let wantsHtml = '';
				if (user.wants) {
					wantsHtml = `<div class="mt-1 d-flex flex-wrap">${user.wants.split(',').map(item => item ? `<span class="badge bg-info text-dark me-1 mb-1">${escapeHtml(item)}</span>` : '' ).join('')}</div>`;
				}
		
				let hopesHtml = '';
				if (user.hopes) {
					hopesHtml = `<div class="mt-1 d-flex flex-wrap">${user.hopes.split(',').map(item => item ? `<span class="badge bg-success me-1 mb-1">${escapeHtml(item)}</span>` : '' ).join('')}</div>`;
				}
		
				let profileMessageHtml = '';
				if (user.profile_message) {
					// 自分自身、または覗き見モードでないユーザーの一言メッセージは表示
					if (user.user_id == MY_USER_ID || !isFormallySpectator) {
						const collapseId = `profile-msg-${user.user_id}`;
						const isOpened = openedProfileMessages.has(parseInt(user.user_id, 10));
						const showClass = isOpened ? ' show' : '';
						const ariaExpanded = isOpened ? 'true' : 'false';
						profileMessageHtml = `<div class="mt-2"><a class="small text-decoration-none text-muted" data-bs-toggle="collapse" href="#${collapseId}" role="button" aria-expanded="${ariaExpanded}"><i class="bi bi-chat-left-text-fill"></i> 一言メッセージ</a><div class="collapse mt-1${showClass}" id="${collapseId}"><div class="card card-body p-2 small" style="background-color: #333;">${escapeHtml(user.profile_message).replace(/\n/g, '<br>')}</div></div></div>`;
					}
				}
				// ▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲▲
		
				let adminButtonsHtml = '';
				if (user.user_id == MY_USER_ID && user.is_creator) {
					const lockBtnClass = isRoomLocked ? 'btn-warning' : 'btn-outline-warning';
					const lockBtnIcon = isRoomLocked ? 'bi-unlock-fill' : 'bi-lock-fill';
					const lockBtnText = isRoomLocked ? 'オープン' : '入室制限';
					const lockButton = `<button type="button" id="toggle-lock-btn" class="btn btn-sm ${lockBtnClass} me-2" title="入室制限/解除"><i class="bi ${lockBtnIcon}"></i> ${lockBtnText}</button>`;
					const closeButton = `<button type="button" class="btn btn-sm btn-danger close-room-btn" title="ルームを閉鎖" data-room-id="${ROOM_ID}" data-room-name="${escapeHtml(ROOM_NAME)}"><i class="bi bi-x-octagon-fill"></i> 閉鎖</button>`;
					adminButtonsHtml = `<div class="mt-2 pt-2 border-top">${lockButton}${closeButton}</div>`;
				}
				
				let statusClass = '', statusText = '';
				if (user.is_typing && parseInt(user.is_typing, 10)) { statusClass = 'status-typing'; statusText = '入力中'; } 
				else if (user.is_online) { statusClass = 'status-online'; statusText = 'オンライン'; } 
				else { statusClass = 'status-offline'; statusText = 'オフライン';}
				
				let privateMessageBtnHtml = '';
				if (user.user_id != MY_USER_ID && !isFormallySpectator) {
					privateMessageBtnHtml = `<button class="btn btn-sm btn-outline-primary private-message-btn ms-2" title="${escapeHtml(user.user_name)}さんにPM送信" data-user-id="${user.user_id}" data-user-name="${escapeHtml(user.user_name)}"><i class="bi bi-envelope-fill"></i></button>`;
				}
				const statusAndButtonsHtml = `<div class="flex-shrink-0 ms-2 d-flex align-items-center">${privateMessageBtnHtml}<span class="status-dot ms-2 ${statusClass}" title="${statusText}"></span></div>`;
				
				let kickButtonHtml = '';
				if (iAmCreator && user.user_id != MY_USER_ID) {
					kickButtonHtml = `<div class="mt-1"><button class="btn btn-sm btn-outline-danger kick-user-btn" title="強制退室" data-user-id="${user.user_id}" data-user-name="${escapeHtml(user.user_name)}"><i class="bi bi-box-arrow-right"></i></button></div>`;
				}
		
				const iconHtml = `<img src="uploads/${escapeHtml(user.icon_image || 'default_icon.png')}" class="rounded-0" style="width: 40px; height: 40px; object-fit: cover;">`;
				
				return `<li class="list-group-item user-list-item" data-user-id="${user.user_id}">
							<div class="d-flex w-100">
								<div class="flex-shrink-0 me-2">${iconHtml}</div>
								<div class="flex-grow-1" style="min-width: 0;">
									${userNameHtml}
									${profileText}
								</div>
								${statusAndButtonsHtml}
							</div>
							${tastesHtml}
							${wantsHtml}
							${hopesHtml}
							${profileMessageHtml}
							${kickButtonHtml}
							${adminButtonsHtml}
						</li>`;
			}).join('');
			$('#user-list, #user-list-offcanvas').html(userListHtml);
		}
		function initLightbox() { const lightboxHtml = `<div id="image-lightbox-overlay"><div id="image-lightbox-caption"><span class="fw-bold me-auto">画像ビューア</span><div class="btn-group btn-group-sm" role="group"><button type="button" class="btn btn-outline-light zoom-btn" id="zoom-out-btn"><i class="bi bi-zoom-out"></i></button><button type="button" class="btn btn-outline-light zoom-btn" id="zoom-in-btn"><i class="bi bi-zoom-in"></i></button></div><button type="button" class="btn btn-sm btn-danger report-btn ms-2"><i class="bi bi-exclamation-triangle-fill"></i> 通報</button><button type="button" class="btn btn-sm btn-secondary close-lightbox-btn ms-2"><i class="bi bi-x-lg"></i></button></div><div id="image-lightbox-container"><img src="" alt="拡大画像"></div><div id="resize-handle"></div></div>`; $('body').append(lightboxHtml); $lightboxOverlay = $('#image-lightbox-overlay').hide(); $lightboxContainer = $('#image-lightbox-container'); $lightboxImage = $lightboxOverlay.find('img'); $reportBtn = $lightboxOverlay.find('.report-btn'); }
		function removeDeletedMessages(deletedIds) { deletedIds.forEach(id => { const t = $(`#log-${id}`); if (t.length) t.fadeOut(500, function() { $(this).remove(); }); }); }
		function updateRoomUI(data) { const statusIndicator = $('#room-status-indicator, #room-status-indicator-offcanvas'); const flagsIndicator = $('#room-flags-indicator, #room-flags-indicator-offcanvas'); let roomFlagsHtml = ''; if (data.flag_meet !== undefined) { if (parseInt(data.flag_meet, 10)) roomFlagsHtml += `<span class="ms-1">${ICON_HTML.meet}</span>`; if (parseInt(data.flag_chatplay, 10)) roomFlagsHtml += `<span class="ms-1">${ICON_HTML.chatplay}</span>`; if (parseInt(data.flag_onlyreal, 10)) roomFlagsHtml += `<span class="ms-1">${ICON_HTML.onlyreal}</span>`; if (parseInt(data.flag_friend, 10)) roomFlagsHtml += `<span class="ms-1">${ICON_HTML.friend}</span>`; $('#header-room-title').html(escapeHtml(ROOM_NAME) + roomFlagsHtml); flagsIndicator.html(roomFlagsHtml); } if (data.is_locked == 1) { statusIndicator.html(`<div class="alert alert-warning p-2 text-center"><i class="bi bi-lock-fill me-1"></i><strong>入室制限中</strong></div>`); } else { statusIndicator.html(''); } }
		function playBeep() { $('#beep-sound')[0].play().catch(e => console.warn("Beep play was prevented:", e)); }
		function escapeHtml(str) { if (str === null || typeof str === 'undefined') return ''; return $('<div>').text(str).html(); }
		function scrollToBottom() { chatLogContainer.scrollTop(chatLogContainer[0].scrollHeight); }
		function isScrolledToBottom() { return chatLogContainer[0].scrollHeight - chatLogContainer.scrollTop() <= chatLogContainer.outerHeight() + 5; }
		function applyZoom(delta) { scale = Math.max(1, Math.min(3, scale + delta)); $lightboxImage.css('transform', `scale(${scale})`); updateZoomButtons(); }
		function updateZoomButtons() { $('#zoom-in-btn').prop('disabled', scale >= 3); $('#zoom-out-btn').prop('disabled', scale <= 1); }
		function showLightbox(e) { e.preventDefault(); const $link = $(this); const imageUrl = $link.attr('href'); const $messageElement = $link.closest('.chat-message'); const logId = $messageElement.attr('id').replace('log-', ''); $lightboxImage.attr('src', imageUrl); $reportBtn.data('log-id', logId); $reportBtn.data('target-image-container', $messageElement.find('.image-container')); scale = 1; $lightboxImage.css('transform', 'scale(1)'); updateZoomButtons(); $lightboxOverlay.css({ top: '', left: '', bottom: '90px', right: '20px', height: 'auto', width: '350px' }); $lightboxContainer.css('height', '300px'); if (!$lightboxOverlay.is(':visible')) { $lightboxOverlay.fadeIn(200); } }
		function hideLightbox() { $lightboxOverlay.fadeOut(200); }
		function loadProfileForm() { const contentArea = $('#profile-form-content'); contentArea.html('<div class="spinner-border" role="status"><span class="visually-hidden">読み込み中...</span></div>'); $('#profile-update-status').text(''); $.ajax({ url: 'get_profile_form.php', type: 'GET', dataType: 'html', }).done(function(response) { contentArea.html(response); }).fail(function() { contentArea.html('<div class="alert alert-danger">プロフィールの読み込みに失敗しました。</div>'); }); }
	
	});