<?php

// FILE: logout.php (PRODUCTION)
session_start(['cookie_samesite' => 'None', 'cookie_secure' => true, 'cookie_httponly' => true]);
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

if (isset($_SESSION['user_id'])) {
    try {
        $pdo = get_pdo();
        $pdo->beginTransaction();
        $user_id = $_SESSION['user_id'];
        $last_room_id = $_SESSION['room_id'] ?? null;
        $user_name = $_SESSION['user_name'] ?? '';
        $stmt = $pdo->prepare("SELECT is_spectator, log_expire_days FROM users3 WHERE user_id = :user_id");
        $stmt->execute([':user_id' => $user_id]);
        $settings = $stmt->fetch();
        $is_spectator = $settings['is_spectator'] ?? 0;
        $should_delete_logs = isset($settings['log_expire_days']) && $settings['log_expire_days'] == 0;
        if ($last_room_id) {
            $online_threshold = date('Y-m-d H:i:s', time() - ONLINE_THRESHOLD_SECONDS);
            $stmt_count = $pdo->prepare("SELECT COUNT(*) FROM online_status WHERE room_id = :room_id AND user_id != :user_id AND last_active > :threshold");
            $stmt_count->execute([':room_id' => $last_room_id, ':user_id' => $user_id, ':threshold' => $online_threshold]);
            $remaining_users = $stmt_count->fetchColumn();
            $stmt_room_info = $pdo->prepare("SELECT created_by, fixed FROM chat_rooms WHERE room_id = :room_id");
            $stmt_room_info->execute([':room_id' => $last_room_id]);
            $room = $stmt_room_info->fetch();
            if ($room) {
                if ($room['created_by'] == $user_id) {
                    $stmt_next_admin = $pdo->prepare("SELECT user_id FROM online_status WHERE room_id = :room_id AND user_id != :user_id ORDER BY created_at ASC LIMIT 1");
                    $stmt_next_admin->execute([':room_id' => $last_room_id, ':user_id' => $user_id]);
                    $next_admin_id = $stmt_next_admin->fetchColumn();
                    if ($next_admin_id) {
                        $pdo->prepare("UPDATE chat_rooms SET created_by = :next_admin_id WHERE room_id = :room_id")->execute([':next_admin_id' => $next_admin_id, ':room_id' => $last_room_id]);
                        $stmt_new_admin_name = $pdo->prepare("SELECT user_name FROM users3 WHERE user_id = :user_id");
                        $stmt_new_admin_name->execute([':user_id' => $next_admin_id]);
                        $new_admin_name = $stmt_new_admin_name->fetchColumn();
                        $transfer_message = h($user_name) . "さんが退室したため、" . h($new_admin_name) . "さんが新しい管理者になりました。";
                        $pdo->prepare("INSERT INTO chat_log3 (room_id, message, is_system) VALUES (:room_id, :message, 1)")->execute([':room_id' => $last_room_id, ':message' => $transfer_message]);
                    } else {
                        $pdo->prepare("UPDATE chat_rooms SET description = '', is_locked = 0 WHERE room_id = :room_id")->execute([':room_id' => $last_room_id]);
                    }
                }
                if ($remaining_users == 0 && $room['fixed'] == 0) {
                    $pdo->prepare("DELETE FROM chat_rooms WHERE room_id = :room_id")->execute([':room_id' => $last_room_id]);
                }
            }
        }
        if ($should_delete_logs) {
            $stmt_get_files = $pdo->prepare("SELECT file_path FROM chat_log3 WHERE user_id = :user_id AND file_path IS NOT NULL");
            $stmt_get_files->execute([':user_id' => $user_id]);
            $files_to_delete = $stmt_get_files->fetchAll(PDO::FETCH_COLUMN, 0);
            foreach ($files_to_delete as $file) {
                if (!empty($file) && file_exists($file)) {
                    @unlink($file);
                }
            }
            $pdo->prepare("DELETE FROM chat_log3 WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
        }
        if ($is_spectator == 0 && defined('ENABLE_AUTO_LEAVE_LOG') && ENABLE_AUTO_LEAVE_LOG === true && $last_room_id && $user_name) {
            $system_message = h($user_name) . 'さんが退室しました';
            $pdo->prepare("INSERT INTO chat_log3 (room_id, message, is_system) VALUES (:room_id, :msg, 1)")
                ->execute([':room_id' => $last_room_id, ':msg' => $system_message]);
        }
        $pdo->prepare("DELETE FROM online_status WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
        $pdo->prepare("DELETE FROM typing_status WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
        $pdo->prepare("UPDATE users3 SET last_active_room_id = NULL WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
        $pdo->commit();
        if ($last_room_id) {
            touch_user_list_update_timestamp($last_room_id);
        }
    } catch (PDOException $e) {
        if (isset($pdo) && $pdo->inTransaction()) {
            $pdo->rollBack();
        }
        error_log("Logout DB process failed: " . $e->getMessage());
    }
}

clear_room_list_cache();
$_SESSION = array();
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
}
session_destroy();

header('Location: index.php');
exit;
