<?php

// FILE: leave_room.php (PRODUCTION)
date_default_timezone_set('Asia/Tokyo');
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error_log.txt');
error_reporting(E_ALL);

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);
if (empty($data) || !isset($data['user_id']) || !isset($data['room_id'])) {
    http_response_code(400);
    exit;
}
$user_id = filter_var($data['user_id'], FILTER_VALIDATE_INT);
$room_id = filter_var($data['room_id'], FILTER_VALIDATE_INT);
$user_name = h($data['user_name'] ?? '誰か');
if ($user_id === false || $room_id === false) {
    http_response_code(400);
    exit;
}
try {
    $pdo = get_pdo();
    $pdo->beginTransaction();
    if ($room_id) {
        $online_threshold = date('Y-m-d H:i:s', time() - ONLINE_THRESHOLD_SECONDS);
        $stmt_count = $pdo->prepare("SELECT COUNT(*) FROM online_status WHERE room_id = :room_id AND user_id != :user_id AND last_active > :threshold");
        $stmt_count->execute([':room_id' => $room_id, ':user_id' => $user_id, ':threshold' => $online_threshold]);
        $remaining_users = $stmt_count->fetchColumn();
        $stmt_room_info = $pdo->prepare("SELECT created_by, fixed FROM chat_rooms WHERE room_id = :room_id");
        $stmt_room_info->execute([':room_id' => $room_id]);
        $room = $stmt_room_info->fetch();
        if ($room) {
            if ($room['created_by'] == $user_id) {
                $stmt_next_admin = $pdo->prepare("SELECT user_id FROM online_status WHERE room_id = :room_id AND user_id != :user_id ORDER BY created_at ASC LIMIT 1");
                $stmt_next_admin->execute([':room_id' => $room_id, ':user_id' => $user_id]);
                $next_admin_id = $stmt_next_admin->fetchColumn();
                if ($next_admin_id) {
                    $pdo->prepare("UPDATE chat_rooms SET created_by = :next_admin_id WHERE room_id = :room_id")->execute([':next_admin_id' => $next_admin_id, ':room_id' => $room_id]);
                    $stmt_new_admin_name = $pdo->prepare("SELECT user_name FROM users3 WHERE user_id = :user_id");
                    $stmt_new_admin_name->execute([':user_id' => $next_admin_id]);
                    $new_admin_name = $stmt_new_admin_name->fetchColumn();
                    $transfer_message = h($user_name) . "さんが退室したため、" . h($new_admin_name) . "さんが新しい管理者になりました。";
                    $pdo->prepare("INSERT INTO chat_log3 (room_id, message, is_system) VALUES (:room_id, :message, 1)")->execute([':room_id' => $room_id, ':message' => $transfer_message]);
                } else {
                    $pdo->prepare("UPDATE chat_rooms SET description = '', is_locked = 0 WHERE room_id = :room_id")->execute([':room_id' => $room_id]);
                }
            }
            if ($remaining_users == 0 && $room['fixed'] == 0) {
                $pdo->prepare("DELETE FROM chat_rooms WHERE room_id = :room_id")->execute([':room_id' => $room_id]);
            }
        }
    }
    if ($room_id && defined('ENABLE_AUTO_LEAVE_LOG') && ENABLE_AUTO_LEAVE_LOG === true) {
        $message = $user_name . 'さんが退室しました(自動)';
        $pdo->prepare("INSERT INTO chat_log3 (room_id, message, is_system) VALUES (:room_id, :message, 1)")
            ->execute([':room_id' => $room_id, ':message' => $message]);
    }
    $pdo->prepare("DELETE FROM online_status WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
    $pdo->prepare("DELETE FROM typing_status WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
    $pdo->prepare("UPDATE users3 SET last_active_room_id = NULL WHERE user_id = :user_id")->execute([':user_id' => $user_id]);
    $pdo->commit();
    clear_room_list_cache();
    if ($room_id) {
        touch_user_list_update_timestamp($room_id);
    }
    http_response_code(204);
} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    error_log("leave_room.php failed: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
    http_response_code(500);
}
exit;
