<?php
// FILE: get_profile_form.php
session_start(['cookie_samesite' => 'None', 'cookie_secure' => true, 'cookie_httponly' => true]);
require_once 'db.php';
require_once 'functions.php';
require_once 'config.php';

if (!isset($_SESSION['user_id'])) {
	http_response_code(401);
	exit;
}

$pdo = get_pdo();
$user_id = $_SESSION['user_id'];

// CSRFトークンを生成して返す
generate_csrf_token();
$csrf_token = $_SESSION['csrf_token'];

// profile.phpから必要なデータを取得するロジックを流用
$usertypes = $pdo->query("SELECT usertype FROM usertype ORDER BY sortkey ASC, usertype ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
$tastes = $pdo->query("SELECT feel FROM taste ORDER BY sortkey ASC, feel ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
$wants = $pdo->query("SELECT want FROM want ORDER BY wantid ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
$hopes = $pdo->query("SELECT hope FROM hope ORDER BY hopeid ASC")->fetchAll(PDO::FETCH_COLUMN, 0);
$areas = $pdo->query("SELECT areaname FROM area ORDER BY areacode ASC")->fetchAll(PDO::FETCH_COLUMN, 0);

$sql = "SELECT user_id, user_name, icon_image, profile_message, usertype, height, weight, age, areaname, tastes, wants, hopes, beep_enabled, log_expire_days, flag_meet, flag_chatplay, flag_onlyreal, flag_friend FROM users3 WHERE user_id = :user_id";
$stmt = $pdo->prepare($sql);
$stmt->execute([':user_id' => $user_id]);
$user = $stmt->fetch();

if (!$user) {
	http_response_code(404);
	exit;
}

if (!isset($user['log_expire_days'])) {
	$user['log_expire_days'] = '1';
}

$user_tastes = !empty($user['tastes']) ? explode(',', $user['tastes']) : [];
$user_wants = !empty($user['wants']) ? explode(',', $user['wants']) : [];
$user_hopes = !empty($user['hopes']) ? explode(',', $user['hopes']) : [];

// is_room_creatorのチェック
$is_room_creator = false;
$stmt_check_creator = $pdo->prepare("SELECT 1 FROM chat_rooms WHERE created_by = :user_id LIMIT 1");
$stmt_check_creator->execute([':user_id' => $user_id]);
if ($stmt_check_creator->fetch()) {
	$is_room_creator = true;
}

// ここからHTMLを出力
?>
<input type="hidden" name="csrf_token" value="<?= h($csrf_token) ?>">
<div class="text-center mb-3">
	<img src="uploads/<?= h($user['icon_image'] ?? DEFAULT_ICON_FILENAME) ?>" id="profile-icon-preview" class="rounded" style="width: 150px; height: 150px; object-fit: cover;" alt="icon">
</div>
<div class="mb-3">
	<label for="prof-user_name" class="form-label">ユーザー名</label>
	<input type="text" class="form-control" id="prof-user_name" name="user_name" value="<?= h($user['user_name'] ?? '') ?>" required>
</div>
<div class="mb-3">
	<label for="prof-profile_message" class="form-label">プロフィールメッセージ
		<?php if ($is_room_creator): ?>
			<span class="text-warning small ms-2">（チャット一覧に公開されます）</span>
		<?php endif; ?>
	</label>
	<textarea class="form-control" id="prof-profile_message" name="profile_message" rows="2" placeholder="チャットルームの参加者リストなどで表示される一言メッセージです"><?= h($user['profile_message'] ?? '') ?></textarea>
</div>
<div class="mb-3">
	<label for="prof-icon_image" class="form-label">アイコン画像</label>
	<input class="form-control" type="file" id="prof-icon_image" name="icon_image" accept="image/jpeg,image/png,image/gif">
	<div class="form-text text-muted small">2MBまでのjpeg,jpg,png,gifの静止画のみ可</div>
	<div class="form-check mt-2">
		<input class="form-check-input" type="checkbox" name="delete_icon" value="1" id="prof-delete_icon">
		<label class="form-check-label" for="prof-delete_icon">アイコンを削除してデフォルトに戻す</label>
	</div>
</div>
<div class="row g-2 mb-2">
	<div class="col-md-5"><label for="prof-usertype" class="form-label">タイプ</label><select class="form-select" id="prof-usertype" name="usertype"><option value="">選択しない</option><?php foreach ($usertypes as $type): ?><option value="<?= h($type) ?>" <?= (($user['usertype'] ?? '') == $type) ? 'selected' : '' ?>><?= h($type) ?></option><?php endforeach; ?></select></div>
	<div class="col"><label for="prof-height" class="form-label">身長</label><input type="text" class="form-control" id="prof-height" name="height" value="<?= h($user['height'] ?? '') ?>" pattern="[0-9]*"></div>
	<div class="col"><label for="prof-weight" class="form-label">体重</label><input type="text" class="form-control" id="prof-weight" name="weight" value="<?= h($user['weight'] ?? '') ?>" pattern="[0-9]*"></div>
	<div class="col"><label for="prof-age" class="form-label">年齢</label><input type="text" class="form-control" id="prof-age" name="age" value="<?= h($user['age'] ?? '') ?>" pattern="[0-9]*"></div>
</div>
<div class="mb-3"><label for="prof-areaname" class="form-label">エリア</label><select class="form-select" id="prof-areaname" name="areaname"><option value="">選択しない</option><?php foreach ($areas as $area): ?><option value="<?= h($area) ?>" <?= (($user['areaname'] ?? '') == $area) ? 'selected' : '' ?>><?= h($area) ?></option><?php endforeach; ?></select></div>
<div class="mb-3">
	<label class="form-label d-block">自分</label>
	<div>
		<?php foreach ($tastes as $i => $item): $id = 'prof_taste_' . $i; ?><div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="tastes[]" value="<?= h($item) ?>" id="<?= $id ?>" <?= in_array($item, $user_tastes) ? 'checked' : '' ?>><label class="form-check-label" for="<?= $id ?>"><?= h($item) ?></label></div><?php endforeach; ?>
	</div>
</div>
<div class="mb-3">
	<label class="form-label d-block">希望の相手</label>
	<div>
		<?php foreach ($wants as $i => $item): $id = 'prof_want_' . $i; ?><div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="wants[]" value="<?= h($item) ?>" id="<?= $id ?>" <?= in_array($item, $user_wants) ? 'checked' : '' ?>><label class="form-check-label" for="<?= $id ?>"><?= h($item) ?></label></div><?php endforeach; ?>
	</div>
</div>
<div class="mb-3">
	<label class="form-label d-block">何が好き？</label>
	<div>
		<?php foreach ($hopes as $i => $item): $id = 'prof_hope_' . $i; ?><div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="hopes[]" value="<?= h($item) ?>" id="<?= $id ?>" <?= in_array($item, $user_hopes) ? 'checked' : '' ?>><label class="form-check-label" for="<?= $id ?>"><?= h($item) ?></label></div><?php endforeach; ?>
	</div>
</div>
<hr>
<h5 class="mt-4">各種設定</h5>
<div class="d-flex flex-wrap align-items-center justify-content-start column-gap-3 row-gap-2">
	<div class="form-check form-switch">
		<input class="form-check-input" type="checkbox" id="prof-beep_enabled" name="beep_enabled" value="1" <?= ($user['beep_enabled'] == 1) ? 'checked' : '' ?>>
		<label class="form-check-label" for="prof-beep_enabled">通知音</label>
	</div>
</div>
<div class="mt-3">
	<label class="form-label d-block mb-1">チャットログ有効期間</label>
	<div class="d-flex flex-wrap column-gap-3 row-gap-1">
		<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="prof_expire_0" value="0" <?= ($user['log_expire_days'] == '0') ? 'checked' : '' ?>><label class="form-check-label" for="prof_expire_0">退室時に削除</label></div>
		<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="prof_expire_1" value="1" <?= ($user['log_expire_days'] == '1') ? 'checked' : '' ?>><label class="form-check-label" for="prof_expire_1">1日後に削除</label></div>
		<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="prof_expire_7" value="7" <?= ($user['log_expire_days'] == '7') ? 'checked' : '' ?>><label class="form-check-label" for="prof_expire_7">7日後に削除</label></div>
		<div class="form-check"><input class="form-check-input" type="radio" name="log_expire_days" id="prof_expire_m1" value="-1" <?= ($user['log_expire_days'] == '-1') ? 'checked' : '' ?>><label class="form-check-label" for="prof_expire_m1">削除しない</label></div>
	</div>
</div>
<div class="mt-3 d-flex flex-wrap align-items-center justify-content-start column-gap-3 row-gap-2">
	<div class="form-check"><input class="form-check-input" type="checkbox" name="flag_meet" value="1" id="prof-flag_meet" <?= ($user['flag_meet'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="prof-flag_meet"><?= ICON_MEET ?> 待ち合わせ</label></div>
	<div class="form-check"><input class="form-check-input" type="checkbox" name="flag_chatplay" value="1" id="prof-flag_chatplay" <?= ($user['flag_chatplay'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="prof-flag_chatplay"><?= ICON_CHATPLAY ?> イメチャ</label></div>
	<div class="form-check"><input class="form-check-input" type="checkbox" name="flag_onlyreal" value="1" id="prof-flag_onlyreal" <?= ($user['flag_onlyreal'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="prof-flag_onlyreal"><?= ICON_ONLYREAL ?> リアルのみ</label></div>
	<div class="form-check"><input class="form-check-input" type="checkbox" name="flag_friend" value="1" id="prof-flag_friend" <?= ($user['flag_friend'] == 1) ? 'checked' : '' ?>><label class="form-check-label" for="prof-flag_friend"><?= ICON_FRIEND ?> 彼氏彼女募集</label></div>
</div>