<?php
// FILE: db.php
if (in_array($_SERVER['SERVER_NAME'] ?? '', ['localhost', '127.0.0.1'])) {
	ini_set('display_errors', 1);
	error_reporting(E_ALL);
} else {
	ini_set('display_errors', 0);
	ini_set('log_errors', 1);
}
require_once __DIR__ . '/config.php';

function get_pdo() {
	$dsn = 'mysql:dbname=' . DB_NAME . ';host=' . DB_HOST . ';charset=utf8mb4';
	try {
		$options = [
			PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
			PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
			PDO::ATTR_EMULATE_PREPARES => false,
		];
		$pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
		$pdo->exec("SET time_zone = '+09:00'");
		return $pdo;
	} catch (PDOException $e) {
		header('Content-Type: text/html; charset=utf-8');
		echo "<h1>データベース接続エラー</h1>";
		echo "<p style='font-size: 1.2em; font-weight: bold; color: red;'>データベースへの接続に失敗しました。設定を確認してください。</p>";
		echo "<h2>エラーメッセージ:</h2>";
		echo "<pre style='font-size: 1.1em; background-color: #f0f0f0; padding: 10px; border: 1px solid #ccc; white-space: pre-wrap; word-wrap: break-word;'>";
		echo "<strong>" . htmlspecialchars($e->getMessage()) . "</strong>";
		echo "</pre>";
		echo "<h2>DSN情報:</h2>";
		echo "<p>" . htmlspecialchars($dsn) . "</p>";
		echo "<h2>ユーザー名:</h2>";
		echo "<p>" . htmlspecialchars(DB_USER) . "</p>";
		exit;
	}
}