<?php
// FILE: close_room.php
session_start([
	'cookie_samesite' => 'None',
	'cookie_secure' => true,
	'cookie_httponly' => true,
]);

require_once 'db.php';
require_once 'config.php';
require_once 'functions.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_SESSION['user_id'])) {
	header('Location: index.php');
	exit;
}
validate_csrf_token();

$user_id = $_SESSION['user_id'];
$room_id_to_close = $_POST['room_id_to_close'] ?? 0;

if (empty($room_id_to_close)) {
	header('Location: index.php?error=invalid_request');
	exit;
}

try {
	$pdo = get_pdo();

	$stmt_check = $pdo->prepare("SELECT created_by, fixed FROM chat_rooms WHERE room_id = :room_id");
	$stmt_check->execute([':room_id' => $room_id_to_close]);
	$room = $stmt_check->fetch();

	if (!$room || $room['created_by'] != $user_id || $room['fixed'] == 1) {
		header('Location: logout.php');
		exit;
	}
	
	$stmt_get_files = $pdo->prepare("SELECT file_path FROM chat_log3 WHERE room_id = :room_id AND file_path IS NOT NULL");
	$stmt_get_files->execute([':room_id' => $room_id_to_close]);
	$files_to_delete = $stmt_get_files->fetchAll(PDO::FETCH_COLUMN, 0);

	foreach ($files_to_delete as $file) {
		if (!empty($file) && file_exists($file)) {
			@unlink($file);
		}
	}

	$pdo->prepare("DELETE FROM chat_log3 WHERE room_id = :room_id")->execute([':room_id' => $room_id_to_close]);
	$pdo->prepare("DELETE FROM chat_rooms WHERE room_id = :room_id")->execute([':room_id' => $room_id_to_close]);

	header('Location: logout.php');
	exit;

} catch (Exception $e) {
	error_log("Room closing failed: " . $e->getMessage());
	header('Location: logout.php');
	exit;
}