<?php
// FILE: chat.php (PRODUCTION)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
header("Pragma: no-cache");
require_once 'config.php';
session_start(['cookie_samesite' => 'None','cookie_secure' => true,'cookie_httponly' => true]);
require_once 'db.php';
require_once 'functions.php';
generate_csrf_token();
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}
$pdo = get_pdo();
$user_id = $_SESSION['user_id'];
$user_name = h($_SESSION['user_name']);
$room_id = $_SESSION['room_id'];
$room_name = h($_SESSION['room_name']);
if (($_POST['cmd'] ?? "") === "clearlog") {
    validate_csrf_token();
    $stmt_clearlog = $pdo->prepare("DELETE FROM chat_log3 WHERE room_id = :room_id AND user_id = :user_id");
    $stmt_clearlog->execute([':room_id' => $room_id, ':user_id' => $user_id]);
    header('Location: chat.php');
    exit;
}
$stmt_room = $pdo->prepare("SELECT created_by, is_locked, fixed, flag_meet, flag_chatplay, flag_onlyreal, flag_friend FROM chat_rooms WHERE room_id = :room_id");
$stmt_room->execute([':room_id' => $room_id]);
$room_info = $stmt_room->fetch();
if ($room_info === false) {
    session_destroy();
    header('Location: index.php?error=room_not_found');
    exit;
}
$room_creator_id = $room_info['created_by'];
$stmt_user_settings = $pdo->prepare("SELECT auto_leave_on_close FROM users3 WHERE user_id = :user_id");
$stmt_user_settings->execute([':user_id' => $user_id]);
$user_settings = $stmt_user_settings->fetch();
$auto_leave_on_close = $user_settings['auto_leave_on_close'] ?? 1;
?>
<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $room_name ?> - <?= h(SITE_NAME) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/chat.css?v=<?php echo time(); ?>">
    <style>
    .message-bubble.offline {
        background-color: <?=h(MESSAGE_BG_OFFLINE) ?> !important;
        opacity: 0.8;
    }
    </style>
</head>

<body data-bs-theme="dark" class="chat-page">
    <header class="navbar navbar-dark bg-dark fixed-top custom-header">
        <div class="container-fluid">
            <div class="row w-100 m-0">
                <div class="col text-center p-0"><a class="navbar-brand room-title" href="#" id="header-room-title"><?= $room_name ?></a></div>
            </div>
            <div class="row w-100 m-0 mt-1">
                <div class="col d-flex justify-content-end align-items-center p-0">
                    <form action="chat.php" method="post" class="m-0">
                        <button type="submit" onclick="return confirm('自分の発言ログを全部削除します。よろしいですか？')" class="btn btn-sm btn-outline-info me-2" title="自分のログ削除" style="white-space: nowrap;"><i class="bi bi-eraser-fill"></i><span class="d-none d-sm-inline"> 自分のログ削除</span></button>
                        <input type="hidden" name="cmd" value="clearlog">
                        <?= csrf_token_field() ?>
                    </form>
                    <button type="button" class="btn btn-sm btn-outline-info me-2" title="プロフィール設定" style="white-space: nowrap;" data-bs-toggle="modal" data-bs-target="#profileModal"><i class="bi bi-person-fill-gear"></i><span class="d-none d-sm-inline"> プロフィール</span></button>
                    <a href="logout.php" class="btn btn-sm btn-outline-danger me-2" title="退室する" style="white-space: nowrap;"><i class="bi bi-box-arrow-right"></i><span> 退室</span></a>
                    <div class="navbar-text text-white text-truncate" title="<?= $user_name ?>"><i class="bi bi-person-circle"></i><span class="d-none d-sm-inline ms-1"><?= $user_name ?></span></div>
                    <button class="btn btn-outline-light d-lg-none ms-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasUsers" aria-controls="offcanvasUsers"><i class="bi bi-people-fill"></i></button>
                </div>
            </div>
        </div>
    </header>
    <div class="container-fluid">
        <div class="row">
            <main class="col chat-area">
                <div id="private-message-indicator" class="alert alert-info" style="display: none;"></div>
                <div id="chat-log" class="chat-log-container">
                    <div id="initial-loading" class="text-center text-muted my-auto">
                        <div class="spinner-border" role="status"><span class="visually-hidden">読み込み中...</span></div>
                        <p class="mt-2">チャット履歴を読み込んでいます...</p>
                    </div>
                    <div id="initial-message" class="text-center text-muted my-auto" style="display: none;">
                        <p class="lead">チャットログはありません。</p>
                        <p>メッセージを入力して、チャットを始めてください。</p>
                    </div>
                </div>
                <div class="message-input-area p-3">
                    <div id="system-notification-area" class="system-notification-container mb-2"></div>
                    <form id="message-form">
                        <div class="input-group">
                            <button class="btn btn-outline-secondary" type="button" id="scroll-to-top-btn" title="一番上へスクロール"><i class="bi bi-list"></i></button>
                            <textarea id="message-input" name="message" class="form-control" placeholder="メッセージを入力... (Shift+Enterで改行)" autocomplete="off" rows="1"></textarea>
                            <label for="file-input" class="btn btn-outline-secondary mb-0"><i class="bi bi-paperclip"></i></label>
                            <input type="file" id="file-input" name="file" class="d-none" accept="image/*">
                            <button class="btn btn-primary" type="submit"><i class="bi bi-send"></i></button>
                        </div>
                        <div id="file-preview" class="mt-2"></div>
                    </form>
                </div>
            </main>
            <aside class="col-md-4 col-lg-3 d-none d-md-block border-start participants-area">
                <div class="p-3">
                    <div id="room-status-indicator" class="mb-3"></div>
                    <div id="room-flags-indicator" class="mb-3 d-flex justify-content-center gap-2"></div>
                    <h5>参加者</h5>
                    <ul id="user-list" class="list-group"></ul>
                    <div class="mt-3 small text-muted">
                        <p class="mb-1"><span class="status-dot status-online me-2"></span>オンライン</p>
                        <?php if (ENABLE_TYPING_NOTIFICATION): ?>
                        <p class="mb-1"><span class="status-dot status-typing me-2"></span>入力中</p>
                        <?php endif; ?>
                        <p class="mb-0"><span class="status-dot status-offline me-2"></span>オフライン</p>
                    </div>
                    <div class="d-grid mt-3"><button class="btn btn-sm btn-outline-secondary" id="refresh-user-list-btn"><i class="bi bi-arrow-clockwise"></i> 最新表示</button></div>
                </div>
            </aside>
        </div>
    </div>
    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasUsers" aria-labelledby="offcanvasUsersLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="offcanvasUsersLabel">参加者</h5><button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <div id="room-status-indicator-offcanvas" class="mb-3"></div>
            <div id="room-flags-indicator-offcanvas" class="mb-3 d-flex justify-content-center gap-2"></div>
            <ul id="user-list-offcanvas" class="list-group"></ul>
            <div class="mt-4 small text-muted border-top pt-3">
                <p class="mb-1"><span class="status-dot status-online me-2"></span>オンライン</p>
                <?php if (ENABLE_TYPING_NOTIFICATION): ?>
                <p class="mb-1"><span class="status-dot status-typing me-2"></span>入力中</p>
                <?php endif; ?>
                <p class="mb-0"><span class="status-dot status-offline me-2"></span>オフライン</p>
            </div>
            <div class="d-grid mt-3"><button class="btn btn-sm btn-outline-secondary" id="refresh-user-list-btn-offcanvas"><i class="bi bi-arrow-clockwise"></i> 最新表示</button></div>
        </div>
    </div>
    <div class="modal fade" id="privateMessageModal" tabindex="-1" aria-labelledby="privateMessageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <form id="private-message-form">
                    <div class="modal-header">
                        <h5 class="modal-title" id="privateMessageModalLabel">プライベートメッセージ</h5><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p id="private-message-recipient"></p>
                        <div class="mb-3"><textarea class="form-control" id="private-message-input" rows="4" required></textarea></div><input type="hidden" id="private-to-user-id" value="">
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">キャンセル</button><button type="submit" class="btn btn-primary">送信</button></div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade modal-lg" id="profileModal" tabindex="-1" aria-labelledby="profileModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="profile-update-form" enctype="multipart/form-data">
                    <div class="modal-header">
                        <h5 class="modal-title" id="profileModalLabel">プロフィール設定</h5><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div id="profile-form-content" class="text-center">
                            <div class="spinner-border" role="status"><span class="visually-hidden">読み込み中...</span></div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div id="profile-update-status" class="me-auto text-success"></div><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">閉じる</button><button type="submit" class="btn btn-primary">更新</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <input type="hidden" id="user_id" value="<?= $user_id ?>">
    <input type="hidden" id="room_id" value="<?= $room_id ?>">
    <input type="hidden" id="room_creator_id" value="<?= h($room_creator_id) ?>">
    <input type="hidden" id="csrf-token-for-ajax" name="csrf_token" value="<?= h($_SESSION['csrf_token']) ?>">
    <input type="hidden" id="ajax-url" value="ajax.php">
    <input type="hidden" id="last_log_id" value="0">
    <input type="hidden" id="room_name_hidden" value="<?= $room_name ?>">
    <input type="hidden" id="user_name_hidden" value="<?= $user_name ?>">
    <input type="hidden" id="auto_leave_on_close_setting" value="<?= h($auto_leave_on_close) ?>">
    <input type="hidden" id="system_message_expire_seconds" value="<?= h(SYSTEM_MESSAGE_EXPIRE_SECONDS) ?>">
    <input type="hidden" id="chat_polling_interval" value="<?= h(CHAT_POLLING_INTERVAL_MS) ?>">
    <input type="hidden" id="users_polling_interval" value="<?= h(USERS_POLLING_INTERVAL_MS) ?>">
    <input type="hidden" id="enable_typing_notification" value="<?= ENABLE_TYPING_NOTIFICATION ? '1' : '0' ?>">
    <input type="hidden" id="enable_auto_link" value="<?= ENABLE_AUTO_LINK ? '1' : '0' ?>">
    <audio id="beep-sound" src="assets/sounds/beep.mp3" preload="auto"></audio>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/chat.js?v=<?php echo time(); ?>"></script>
    <div id="icon-templates" style="display: none;">
        <span id="icon-meet"><?= ICON_MEET ?></span><span id="icon-chatplay"><?= ICON_CHATPLAY ?></span>
        <span id="icon-onlyreal"><?= ICON_ONLYREAL ?></span><span id="icon-friend"><?= ICON_FRIEND ?></span>
        <span id="icon-mobile"><i class="bi bi-phone"></i></span><span id="icon-tablet"><i class="bi bi-tablet"></i></span>
    </div>
</body>

</html>