// FILE: index.js (PRODUCTION - FINAL FIX)
document.addEventListener('DOMContentLoaded', function() {
	function submitJoinForm(roomIdAction) {
		if (typeof jQuery === 'undefined') {
			alert('ページの読み込みが完了していません。もう一度お試しください。');
			return;
		}
		const userName = $('#user_name').val().trim();
		if (!userName) {
			alert('ユーザー名を入力してください。');
			$('#user_name').focus();
			return;
		}
		const newRoomNameInput = $('#new_room_name_input');
		const newRoomName = newRoomNameInput.val().trim();
		if (roomIdAction === 'new_room' && !newRoomName) {
			alert('新しいルーム名を入力してください。');
			newRoomNameInput.focus();
			return;
		}
		const form = $('#join-room-form');
		if (roomIdAction !== 'new_room') {
			const roomItem = $(`.list-group-item[data-room-id="${roomIdAction}"]`);
			form.find('input[name="new_room_name"]').val(roomItem.data('room-name'));
			form.find('input[name="description"]').val(roomItem.data('room-desc'));
		} else {
			form.find('input[name="new_room_name"]').val(newRoomName);
			form.find('input[name="description"]').val($('#description').val().trim());
		}
		form.find('input[name="room_id"]').val(roomIdAction);
		const tastes = $('#taste-checkboxes .taste-check:checked').map(function() { return $(this).val(); }).get().join(',');
		const wants = $('#want-checkboxes .want-check:checked').map(function() { return $(this).val(); }).get().join(',');
		const hopes = $('#hope-checkboxes .hope-check:checked').map(function() { return $(this).val(); }).get().join(',');
		form.find('input[name="user_name"]').val(userName);
		form.find('input[name="usertype"]').val($('#usertype').val());
		form.find('input[name="height"]').val($('#height').val().trim());
		form.find('input[name="weight"]').val($('#weight').val().trim());
		form.find('input[name="age"]').val($('#age').val().trim());
		form.find('input[name="areaname"]').val($('#areaname').val());
		form.find('input[name="tastes"]').val(tastes);
		form.find('input[name="wants"]').val(wants);
		form.find('input[name="hopes"]').val(hopes);
		form.find('input[name="beep_enabled"]').val($('#beep_enabled').is(':checked') ? '1' : '0');
		const logExpireDays = $('input[name="log_expire_days"]:checked').val();
		form.find('input[name="log_expire_days"]').val(logExpireDays);
		form.find('input[name="is_spectator"]').val($('#is_spectator').is(':checked') ? '1' : '0');
		form.find('input[name="flag_meet"]').val($('#flag_meet').is(':checked') ? '1' : '0');
		form.find('input[name="flag_chatplay"]').val($('#flag_chatplay').is(':checked') ? '1' : '0');
		form.find('input[name="flag_onlyreal"]').val($('#flag_onlyreal').is(':checked') ? '1' : '0');
		form.find('input[name="flag_friend"]').val($('#flag_friend').is(':checked') ? '1' : '0');
		form.submit();
	}
	const ICON_HTML = {
		meet: $('#icon-meet').html(),
		chatplay: $('#icon-chatplay').html(),
		onlyreal: $('#icon-onlyreal').html(),
		friend: $('#icon-friend').html(),
		mobile: $('#icon-mobile').html(),
		tablet: $('#icon-tablet').html()
	};
	const NEW_BADGE_TEMPLATE = $('#badge-new').html() || '';
	const MY_HOPES = $('body').data('my-hopes').split(',');

	function escapeHtml(str) {
		if (str === null || typeof str === 'undefined') return '';
		const map = { '&': '&amp;', '<': '&lt;', '>': '&gt;', '"': '&quot;', "'": '&#039;' };
		return String(str).replace(/[&<>"']/g, function(m) { return map[m]; });
	}

	function fetchRooms() {
		const DEFAULT_ICON = $('#default-icon-filename').val();
		const container = $('#room-list-container');
		const refreshButton = $('#refresh-room-list');
		$.ajax({
			url: 'get_rooms.php',
			type: 'GET',
			dataType: 'json',
			cache: false,
			beforeSend: function() { refreshButton.find('i').addClass('fa-spin');
				refreshButton.find('span').text(' 更新中...'); }
		}).done(function(data) {
			if (data.status === 'success' && Array.isArray(data.rooms)) {
				if (data.csrf_token) { $('#join-room-form input[name="csrf_token"]').val(data.csrf_token); }
				if (data.rooms.length > 0) {
					let html = '';
					data.rooms.forEach(function(room) {
						const isLocked = parseInt(room.is_locked, 10) === 1;
						const lockIcon = isLocked ? '<i class="bi bi-lock-fill text-warning me-2" title="制限中"></i>' : '';
						const activityIcon = room.is_recently_active ? `<i class="bi bi-fire text-danger ms-1" title="活発"></i>` : '';
						const newBadge = room.is_new ? NEW_BADGE_TEMPLATE : '';
						const elapsedTimeHtml = room.elapsed_time_str ? `<small class="text-muted ms-2">(${room.elapsed_time_str})</small>` : '';
						let roomFlagIconsHtml = '';
						if (parseInt(room.flag_meet)) roomFlagIconsHtml += `<span class="ms-1">${ICON_HTML.meet}</span>`;
						if (parseInt(room.flag_chatplay)) roomFlagIconsHtml += `<span class="ms-1">${ICON_HTML.chatplay}</span>`;
						if (parseInt(room.flag_onlyreal)) roomFlagIconsHtml += `<span class="ms-1">${ICON_HTML.onlyreal}</span>`;
						if (parseInt(room.flag_friend)) roomFlagIconsHtml += `<span class="ms-1">${ICON_HTML.friend}</span>`;
						let itemClass = isLocked ? 'locked-item locked-room' : 'hover-effect';
						if (!isLocked && room.member_count > 0) { itemClass += ' available-room'; }
						let actionHtml = '';
						if (isLocked) {
							actionHtml = `<span class="badge bg-danger me-2">入室制限中</span><button class="btn btn-sm btn-secondary join-room-btn btn-no-wrap" disabled>入室不可</button>`;
						} else {
							const memberCount = room.member_count > 0 ? `<span class="badge bg-secondary rounded-pill">${room.member_count}人</span>` : '<span class="badge bg-warning text-dark">空室</span>';
							actionHtml = `${memberCount}<button class="btn btn-sm btn-primary ms-3 join-room-btn" data-room-id="${room.room_id}">入室</button>`;
						}
						let membersHtml = '';
						if (room.member_count > 0 && Array.isArray(room.members_data)) {
							membersHtml += '<div class="mt-2 pt-2 border-top ms-4">';
							room.members_data.forEach(member => {
								if (!member) return;

								const is_spectator = parseInt(member.is_spectator || '0', 10) === 1;
								let final_user_name = escapeHtml(member.user_name);
								let spectator_icon = '';

								if (is_spectator) {
									spectator_icon = `<i class="bi bi-incognito me-1" title="覗き見中" style="color: Blueviolet;"></i>`;
								}

								let userNameHtml = '';
								const deviceIcon = member.device_type === 'Mobile' ? ` <span title="モバイル">${ICON_HTML.mobile}</span>` : (member.device_type === 'Tablet' ? ` <span title="タブレット">${ICON_HTML.tablet}</span>` : '');

								if (isLocked) {
									final_user_name = '******';
									userNameHtml = `<div class="fw-bold text-white">${spectator_icon}${final_user_name}${deviceIcon}</div>`;
								} else {
									if (is_spectator) {
										final_user_name = '******';
									}
									userNameHtml = `<div class="fw-bold">${spectator_icon}${final_user_name}${deviceIcon}</div>`;
								}

								const profileParts = [];
								if (member.usertype && member.typecolor) profileParts.push(`<span style="color: ${escapeHtml(member.typecolor)}; font-weight: bold;">${escapeHtml(member.usertype)}</span>`);
								const physicalData = [member.height, member.weight, member.age].filter(p => p).join('/');
								if (physicalData) profileParts.push(escapeHtml(physicalData));
								if (member.areaname && member.area_color) profileParts.push(`<span style="color: ${escapeHtml(member.area_color)};">${escapeHtml(member.areaname)}</span>`);
								const profileTextHtml = profileParts.join(' ');
								let userFlagIconsHtml = '';
								if (parseInt(member.flag_meet)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.meet}</span>`;
								if (parseInt(member.flag_chatplay)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.chatplay}</span>`;
								if (parseInt(member.flag_onlyreal)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.onlyreal}</span>`;
								if (parseInt(member.flag_friend)) userFlagIconsHtml += `<span class="ms-2">${ICON_HTML.friend}</span>`;
								let preferencesHtml = '';
								if (member.hopes) {
									const memberHopes = member.hopes.split(',');
									const hopesHtmlParts = memberHopes.map(hope => {
										const trimmedHope = hope.trim();
										return MY_HOPES.includes(trimmedHope) ? `<span style="color: ${'Magenta'}; font-weight: bold;">${escapeHtml(trimmedHope)}</span>` : escapeHtml(trimmedHope);
									});
									preferencesHtml += `<div><span class="text-warning">[何が好き？: ${hopesHtmlParts.join(', ')}]</span></div>`;
								}
								const iconSrc = `uploads/${escapeHtml(member.icon_image || DEFAULT_ICON)}`;
								membersHtml += `<div class="mb-2"><div class="d-flex align-items-center mb-1"><img src="${iconSrc}" class="rounded-0 me-1" width="32" height="32" style="object-fit: cover;"><div>${userNameHtml}<small class="text-muted" style="line-height: 1.2;">${profileTextHtml}${userFlagIconsHtml}</small></div></div><div class="small" style="margin-left: 40px; line-height: 1.4;">${preferencesHtml}</div></div>`;
							});
							membersHtml += '</div>';
						}
						html += `<li class="list-group-item ${itemClass}" data-room-id="${room.room_id}" data-room-name="${escapeHtml(room.room_name)}" data-room-desc="${escapeHtml(room.description || '')}">
									<div class="d-flex justify-content-between align-items-start">
										<div class="flex-grow-1 me-3" style="min-width: 0;">
											<strong style="color: ${escapeHtml(room.roomcolor || 'inherit')};">${newBadge}${lockIcon}${escapeHtml(room.room_name)}</strong>${elapsedTimeHtml}${roomFlagIconsHtml}${activityIcon}
											<small class="d-block text-muted">${escapeHtml(room.description || ' ')}</small>
										</div>
										<div class="d-flex align-items-center flex-shrink-0">${actionHtml}</div>
									</div>
									${membersHtml}
								 </li>`;
					});
					container.html(html);
				} else {
					container.html('<li class="list-group-item text-center text-muted">現在、参加できるルームはありません。</li>');
				}
			} else {
				container.html('<li class="list-group-item text-center text-danger">ルーム一覧の取得に失敗しました。</li>');
			}
		}).fail(function() {
			container.html('<li class="list-group-item text-center text-danger">サーバーとの通信に失敗しました。</li>');
		}).always(function() {
			refreshButton.find('i').removeClass('fa-spin');
			refreshButton.find('span').text(' 最新表示');
		});
	}

	fetchRooms();
	setInterval(fetchRooms, 30000);
	$('#refresh-room-list').on('click', fetchRooms);
	$('#room-list-container').on('click', '.join-room-btn', function(e) {
		e.stopPropagation();
		submitJoinForm($(this).data('room-id'));
	});
	$('#create-room-btn').on('click', function() {
		submitJoinForm('new_room');
	});
});